/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.grpc;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.grpc.connector.ConnectorServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private Server server;

    private void start() throws IOException {
        int port = Integer.parseInt(Conf.get((String)"common.grpc.server.port"));
        String services = Conf.get((String)"common.grpc.server.service");
        ServerBuilder serverBuilder = ServerBuilder.forPort((int)port).addService((BindableService)ConnectorServer.getInst());
        if (StringUtil.isNotNull((Object)services)) {
            String[] servers;
            for (String serverstr : servers = services.split(",")) {
                try {
                    BindableService newInstance = (BindableService)Class.forName(serverstr).newInstance();
                    serverBuilder.addService(newInstance);
                }
                catch (Exception e) {
                    log.error("\u52a0\u8f7d\u670d\u52a1\u5931\u8d25:{}", (Object)serverstr);
                    throw new RuntimeException("\u52a0\u8f7d\u670d\u52a1\u5931\u8d25:" + serverstr);
                }
            }
        }
        this.server = serverBuilder.build();
        this.server.start();
        log.info("server started, listening on " + port);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.err.println("*** shutting down gRPC server since JVM is shutting down");
                if (Main.this.server != null) {
                    Main.this.server.shutdown();
                }
                System.err.println("*** server shut down");
            }
        });
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Main server = new Main();
        server.start();
        server.blockUntilShutdown();
    }
}

