package net.wicp.tams.common.grpc;

import org.apache.commons.lang3.Validate;

import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.grpc.connector.In;
import net.wicp.tams.common.grpc.connector.In.Builder;

public abstract class GrpcAssit {
	/****
	 * 得到符合要求的参数
	 * 
	 * @param requestCommand
	 * @param jsonobj
	 * @param msgId
	 * @param senderApplication
	 * @param senderChannel
	 * @param senderSystem
	 * @return
	 */
	public static In getIn(String requestCommand, JSONObject jsonobj, String msgId, String senderApplication,
			String senderChannel, String senderSystem) {
		Validate.notBlank(requestCommand);
		Validate.notNull(jsonobj);
		Builder newBuilder = In.newBuilder();
		net.wicp.tams.common.grpc.connector.ControlInfo.Builder controlInfoBuilder = newBuilder.getControlInfoBuilder();
		controlInfoBuilder.setCache(false);
		controlInfoBuilder.setMsgId(StringUtil.hasNull(msgId, "123456"));
		controlInfoBuilder.setRequestCommand(requestCommand);
		controlInfoBuilder.setSenderApplication(
				StringUtil.hasNull(senderApplication, Conf.get("common.connector.dynabean.client.application")));
		controlInfoBuilder.setSenderChannel(
				StringUtil.hasNull(senderChannel, Conf.get("common.connector.dynabean.client.channel")));
		controlInfoBuilder
				.setSenderSystem(StringUtil.hasNull(senderSystem, Conf.get("common.connector.dynabean.client.system")));
		// controlInfoBuilder.setVersion("v1");
		// controlInfoBuilder.setUrl("");// 包装过的可以不用传,其它的需要设置具体地址
		// controlInfoBuilder.setToApplication("TPYB-DEMO");
		newBuilder.setControlInfo(controlInfoBuilder);
		newBuilder.setInput(jsonobj.toJSONString());
		return newBuilder.build();
	}

	public static In getIn(String requestCommand, JSONObject jsonobj) {
		return getIn(requestCommand, jsonobj, null, null, null, null);
	}
}
