/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.grpc.ribbon;

import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.MyDataCenterInstanceConfig;
import com.netflix.client.ClientFactory;
import com.netflix.config.ConfigurationManager;
import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import com.netflix.discovery.CacheRefreshedEvent;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.StatusChangeEvent;
import com.netflix.discovery.shared.transport.jersey.Jersey1DiscoveryClientOptionalArgs;
import com.netflix.eventbus.impl.EventBusImpl;
import com.netflix.eventbus.spi.EventBus;
import com.netflix.eventbus.spi.InvalidSubscriberException;
import com.netflix.eventbus.spi.Subscribe;
import com.netflix.loadbalancer.DynamicServerListLoadBalancer;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.RoundRobinRule;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.grpc.ribbon.event.ICacheRefreshedCallback;
import net.wicp.tams.common.grpc.ribbon.event.IStatusChangeCallback;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RibbonClient {
    private static final Logger log = LoggerFactory.getLogger(RibbonClient.class);
    private static RibbonClient inst = new RibbonClient();
    private final EventBus eventBus;
    private final RoundRobinRule chooseRule = new RoundRobinRule();
    private List<String> hasClient = new ArrayList<String>();
    private Object eventFreshListener = null;
    private Object eventStatusChangeListener = null;

    private RibbonClient() {
        Properties ribbonProp = Conf.getPreToProp((String)"common.grpc.ribbon.default", (boolean)true);
        ConfigurationManager.loadProperties((Properties)ribbonProp);
        Jersey1DiscoveryClientOptionalArgs optionalArgs = new Jersey1DiscoveryClientOptionalArgs();
        this.eventBus = new EventBusImpl();
        optionalArgs.setEventBus(this.eventBus);
        try {
            DiscoveryManager.getInstance().initComponent((EurekaInstanceConfig)new MyDataCenterInstanceConfig(), (EurekaClientConfig)new DefaultEurekaClientConfig(), (AbstractDiscoveryClientOptionalArgs)optionalArgs);
            log.info("ribbon\u521d\u59cb\u5316\u5b8c\u6210");
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316ribbon\u5ba2\u6237\u7aef\u51fa\u9519", (Throwable)e);
        }
    }

    public static RibbonClient getInst() {
        return inst;
    }

    public DynamicServerListLoadBalancer getLb(String clientName) {
        DynamicServerListLoadBalancer lb2 = (DynamicServerListLoadBalancer)ClientFactory.getNamedLoadBalancer((String)clientName);
        return lb2;
    }

    public DiscoveryEnabledServer getServerOne(String clientName) {
        Server selected = this.chooseRule.choose((ILoadBalancer)this.getLb(clientName), null);
        if (null == selected) {
            log.error("\u670d\u52a1{}\u6ca1\u6709\u53ef\u7528\u5730\u5740", (Object)clientName);
            return null;
        }
        return (DiscoveryEnabledServer)selected;
    }

    public List<Server> getServerAvailable(String clientName) {
        List serverList = this.getLb(clientName).getReachableServers();
        if (CollectionUtils.isEmpty((Collection)serverList)) {
            log.error("\u670d\u52a1{}\u6ca1\u6709\u53ef\u7528\u5730\u5740", (Object)clientName);
            return Collections.emptyList();
        }
        return serverList;
    }

    public void addClient(String path) {
        Properties properties = IOUtil.fileToProperties((String)path);
        this.addClient(properties);
    }

    public void addClient(Properties props) {
        ConfigurationManager.loadProperties((Properties)props);
        for (Object key : props.keySet()) {
            String keystr = String.valueOf(key);
            if (!keystr.endsWith(".ribbon.DeploymentContextBasedVipAddresses")) continue;
            this.hasClient.add(keystr.replace(keystr, ".ribbon.DeploymentContextBasedVipAddresses"));
            break;
        }
    }

    public void addClientByAppName(String appName) {
        if (this.hasClient.contains(appName)) {
            return;
        }
        Properties props = new Properties();
        props.put(String.format("%s.ribbon.DeploymentContextBasedVipAddresses", appName), "S3");
        props.put(String.format("%s.ribbon.NIWSServerListClassName", appName), "com.netflix.niws.loadbalancer.DiscoveryEnabledNIWSServerList");
        props.put(String.format("%s.ribbon.ServerListRefreshInterval", appName), "60000");
        props.put(String.format("%s.ribbon.DeploymentContextBasedVipAddresses", appName), appName);
        this.addClient(props);
        this.hasClient.add(appName);
    }

    public Result regFreshEvent(final ICacheRefreshedCallback callback) {
        if (this.eventFreshListener != null) {
            this.eventBus.unregisterSubscriber(this.eventFreshListener);
        }
        this.eventFreshListener = new Object(){

            @Subscribe
            public void consume(CacheRefreshedEvent event) {
                callback.callback(event);
            }
        };
        try {
            this.eventBus.registerSubscriber(this.eventFreshListener);
            return Result.getSuc();
        }
        catch (InvalidSubscriberException e) {
            log.error("\u6ce8\u518c\u5237\u65b0\u4e8b\u4ef6\u5931\u8d25");
            return Result.getError((String)("\u6ce8\u518c\u5237\u65b0\u4e8b\u4ef6\u5931\u8d25,\u539f\u56e0:" + e.getMessage()));
        }
    }

    public Result regStatusChangeEvent(final IStatusChangeCallback callback) {
        if (this.eventStatusChangeListener != null) {
            this.eventBus.unregisterSubscriber(this.eventStatusChangeListener);
        }
        this.eventStatusChangeListener = new Object(){

            @Subscribe
            public void consume(StatusChangeEvent event) {
                callback.callback(event);
            }
        };
        try {
            this.eventBus.registerSubscriber(this.eventStatusChangeListener);
            return Result.getSuc();
        }
        catch (InvalidSubscriberException e) {
            log.error("\u6ce8\u518c\u5237\u65b0\u4e8b\u4ef6\u5931\u8d25");
            return Result.getError((String)("\u6ce8\u518c\u5237\u65b0\u4e8b\u4ef6\u5931\u8d25,\u539f\u56e0:" + e.getMessage()));
        }
    }
}

