/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.grpc.connector;

import com.alibaba.fastjson.JSONObject;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import io.grpc.stub.StreamObserver;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.connector.ConfigInstance;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.executor.IBusiManager;
import net.wicp.tams.common.connector.executor.IConfigManager;
import net.wicp.tams.common.connector.executor.busi.ClassLoadManager;
import net.wicp.tams.common.connector.executor.busi.KeyConfigManager;
import net.wicp.tams.common.connector.executor.impl.CommonService;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.grpc.connector.Admin;
import net.wicp.tams.common.grpc.connector.ConnectorServiceGrpc;
import net.wicp.tams.common.grpc.connector.ControlInfo;
import net.wicp.tams.common.grpc.connector.In;
import net.wicp.tams.common.grpc.connector.Out;
import net.wicp.tams.common.grpc.connector.RespInfo;
import net.wicp.tams.common.grpc.connector.Result;
import net.wicp.tams.common.grpc.ribbon.RibbonClient;
import net.wicp.tams.common.http.HttpClient;
import net.wicp.tams.common.http.HttpResult;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorServer
extends ConnectorServiceGrpc.ConnectorServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(ConnectorServer.class);
    private final KeyConfigManager keyConfigManager;
    private final CommonService executor;
    private static final ConnectorServer connectorServer = new ConnectorServer();
    private RibbonClient ribbonClient = RibbonClient.getInst();

    public static ConnectorServer getInst() {
        return connectorServer;
    }

    private ConnectorServer() {
        this.keyConfigManager = new KeyConfigManager();
        String path = Conf.get((String)"common.grpc.plugin.path");
        path = StringUtil.isNull((Object)path) || "none".equals(path) ? IOUtil.mergeFolderAndFilePath((String)IOUtil.getCurFolder(ConnectorServer.class).getParent(), (String[])new String[]{"/plugin"}) : path;
        ClassLoadManager classLoadManager = new ClassLoadManager(path, Conf.get((String)"common.grpc.plugin.packagebase").split(","));
        this.executor = new CommonService();
        this.executor.setBusiManager((IBusiManager)classLoadManager);
        this.executor.setConfigManager((IConfigManager)this.keyConfigManager);
    }

    @Override
    public void call(In request, StreamObserver<Out> responseObserver) {
        ControlInfo controlInfo = request.getControlInfo();
        JSONObject control = new JSONObject();
        control.put("msgId", (Object)controlInfo.getMsgId());
        control.put("cache", (Object)Boolean.toString(controlInfo.getCache()));
        control.put("requestCommand", (Object)controlInfo.getRequestCommand());
        control.put("senderApplication", (Object)controlInfo.getSenderApplication());
        control.put("senderChannel", (Object)controlInfo.getSenderChannel());
        control.put("senderSystem", (Object)controlInfo.getCache());
        JSONObject json = new JSONObject();
        json.put("ControlInfo", (Object)control);
        JSONObject inputJson = JSONUtil.mergeJSON((JSONObject)json, (JSONObject)JSONObject.parseObject((String)request.getInput()));
        String toApp = controlInfo.getToApplication();
        if (StringUtil.isNull((Object)toApp)) {
            CusDynaBean inputBean = this.keyConfigManager.getInputBeanInputBody(inputJson);
            String appKey = controlInfo.getRequestCommand();
            CusDynaBean outbean = this.executor.exe(inputBean);
            if (outbean == null) {
                outbean = ConfigInstance.getInstance().getNullOutBean(new ProjectException((IExcept)ExceptAll.project_nonull, "\u6ca1\u6709\u627e\u5230" + appKey + "\u5bf9\u5e94\u7684\u4e1a\u52a1\u5b9e\u73b0"));
                log.error("\u6ca1\u6709\u627e\u5230{}\u5bf9\u5e94\u7684\u4e1a\u52a1\u5b9e\u73b0", (Object)appKey);
            }
            responseObserver.onNext((Object)this.convertToOut(outbean));
        } else {
            this.ribbonClient.addClientByAppName(toApp);
            DiscoveryEnabledServer serverOne = this.ribbonClient.getServerOne(toApp);
            if (serverOne == null) {
                CusDynaBean outbean = ConfigInstance.getInstance().getNullOutBean(new ProjectException((IExcept)ExceptAll.project_nonull, "eureka\u4e0a\u6ca1\u6709\u627e\u5230\u6ce8\u518c\u7684\u670d\u52a1" + toApp));
                log.error("eureka\u4e0a\u6ca1\u6709\u627e\u5230\u6ce8\u518c\u7684\u670d\u52a1{}", (Object)toApp);
                responseObserver.onNext((Object)this.convertToOut(outbean));
            } else {
                String url = controlInfo.getUrl();
                String urlstr = IOUtil.mergeFolderAndFilePath((String)serverOne.getInstanceInfo().getHomePageUrl(), (String[])new String[]{StringUtil.isNull((Object)url) ? "/connector" : url});
                HttpResult ret = HttpClient.doPost((String)urlstr, (JSONObject)inputJson, (Header[])new Header[0]);
                JSONObject retobj = JSONObject.parseObject((String)ret.getBodyStr());
                if (retobj.containsKey((Object)"error") && retobj.containsKey((Object)"timestamp")) {
                    responseObserver.onNext((Object)this.doConvertMicro(retobj));
                } else {
                    responseObserver.onNext((Object)this.doConvert(retobj));
                }
            }
        }
        responseObserver.onCompleted();
    }

    @Override
    public void refresh(Admin request, StreamObserver<Result> responseObserver) {
        String token = Conf.get((String)"common.grpc.admin.token");
        boolean ischeck = false;
        ischeck = StringUtil.isNotNull((Object)token) && !"none".equals(token) ? token.equals(request.getToken()) : true;
        if (ischeck) {
            this.executor.getConfigManager().refresh();
            this.executor.getBusiManager().refresh();
            responseObserver.onNext((Object)Result.newBuilder().setRet("1").build());
        } else {
            responseObserver.onNext((Object)Result.newBuilder().setRet("0").build());
        }
        responseObserver.onCompleted();
    }

    private Out convertToOut(CusDynaBean retbean) {
        return this.doConvert(retbean.getJsonObj());
    }

    private Out convertToOut(String retjsonstr) {
        return this.doConvert(JSONObject.parseObject((String)retjsonstr));
    }

    private Out doConvertMicro(JSONObject jsonObj) {
        Out.Builder newBuilder = Out.newBuilder();
        if (jsonObj.containsKey((Object)"status")) {
            newBuilder.setHttp(jsonObj.getString("status"));
        }
        if (jsonObj.containsKey((Object)"error")) {
            newBuilder.setErrMsg(jsonObj.getString("error"));
        }
        if (jsonObj.containsKey((Object)"message")) {
            newBuilder.setErrorDesc(jsonObj.getString("message"));
        }
        if (jsonObj.containsKey((Object)"path")) {
            newBuilder.setErrorCode(jsonObj.getString("path"));
        }
        return newBuilder.build();
    }

    private Out doConvert(JSONObject jsonObj) {
        Out.Builder newBuilder = Out.newBuilder();
        newBuilder.setErrMsg(jsonObj.getString("errMsg"));
        jsonObj.remove((Object)"errMsg");
        newBuilder.setErrorCode(jsonObj.getString("errorCode"));
        jsonObj.remove((Object)"errorCode");
        newBuilder.setErrorDesc(jsonObj.getString("errorDesc"));
        jsonObj.remove((Object)"errorDesc");
        newBuilder.setErrorValue(jsonObj.getIntValue("errorValue"));
        jsonObj.remove((Object)"errorValue");
        newBuilder.setHttp(jsonObj.getString("http"));
        jsonObj.remove((Object)"http");
        JSONObject respInfo = jsonObj.getJSONObject("respInfo");
        RespInfo.Builder respInfoBuilder = newBuilder.getRespInfoBuilder();
        if (respInfo.containsKey((Object)"msgId")) {
            if (StringUtil.isNotNull((Object)respInfo.getString("msgId"))) {
                respInfoBuilder.setMsgId(respInfo.getString("msgId"));
            }
        }
        respInfoBuilder.setReceiptApplication(respInfo.getString("receiptApplication"));
        respInfoBuilder.setMsgIdResp(respInfo.getString("msgIdResp"));
        respInfoBuilder.setReceiptSystem(respInfo.getString("receiptSystem"));
        jsonObj.remove((Object)"respInfo");
        newBuilder.setOutput(JSONObject.toJSONString((Object)jsonObj));
        return newBuilder.build();
    }
}

