/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.sqlgateway.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.apiext.DateUtil;
import net.wicp.tams.common.flink.sqlgateway.jdbc.FlinkResultSetMetaData;
import net.wicp.tams.common.http.flink.ResultType;
import net.wicp.tams.common.http.flink.SqlCmd;
import net.wicp.tams.common.http.flink.SqlGateResultCol;
import net.wicp.tams.common.http.flink.SqlGateResultPo;
import net.wicp.tams.common.http.flink.SqlGateWay;
import org.apache.commons.lang3.ArrayUtils;

public class FlinkResultSet
implements ResultSet {
    public static final long defaultMaxRows = 100L;
    private SqlGateWay sqlGateWay;
    private final SqlGateResultPo sqlGateResultPo;
    private final long maxRows;
    private boolean closed;
    private boolean wasNull;

    public SqlGateResultPo getSqlGateResultPo() {
        return this.sqlGateResultPo;
    }

    public FlinkResultSet(SqlGateWay sqlGateWay, SqlGateResultPo sqlGateResultPo, long maxRows) {
        this.sqlGateWay = sqlGateWay;
        this.closed = false;
        this.wasNull = false;
        this.sqlGateResultPo = sqlGateResultPo;
        this.maxRows = maxRows;
    }

    public FlinkResultSet(SqlGateWay sqlGateWay, String sql, boolean needWaite) {
        this(sqlGateWay, (SqlGateResultPo)sqlGateWay.statementsResultForDDL(sql, needWaite).retObjs(0), 100L);
    }

    public FlinkResultSet(SqlGateResultPo sqlGateResultPo) {
        this(null, sqlGateResultPo, 100L);
    }

    public FlinkResultSet(List<Map<String, String>> datas, String[] cols) {
        this(datas, cols, 100L);
    }

    public FlinkResultSet(List<Map<String, String>> datas, String[] cols, long maxRows) {
        this.sqlGateWay = null;
        this.closed = false;
        this.wasNull = false;
        SqlGateResultPo temp = new SqlGateResultPo();
        temp.setResultType(ResultType.PAYLOAD);
        for (String col : cols) {
            SqlGateResultCol temppo = new SqlGateResultCol(col);
            temp.getCols().add(temppo);
        }
        for (Map map : datas) {
            String[] dataRet = new String[cols.length];
            for (String key : map.keySet()) {
                int indexOf = ArrayUtils.indexOf((Object[])cols, (Object)key);
                if (indexOf < 0) continue;
                dataRet[indexOf] = (String)map.get(key);
            }
            temp.getCurData().add(dataRet);
        }
        this.sqlGateResultPo = temp;
        this.maxRows = maxRows;
    }

    public FlinkResultSet(SqlGateWay sqlGateWay, SqlCmd sqlCmd, Object ... params) {
        this(sqlGateWay.exec(sqlCmd, params));
    }

    public FlinkResultSet(SqlGateWay sqlGateWay, SqlCmd sqlCmd, String[] cols, Object[] params) {
        this(sqlGateWay.execPutCols(sqlCmd, cols, params));
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("This result set is already closed");
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSet#unwrap is not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSet#isWrapperFor is not supported");
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        return this.sqlGateResultPo.next(this.sqlGateWay, this.maxRows);
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.sqlGateResultPo != null && this.sqlGateWay != null) {
            this.sqlGateWay.cancelJob(this.sqlGateResultPo.getOperationHandle());
        }
        this.closed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        String dataStr = this.sqlGateResultPo.getDataCurRow()[columnIndex - 1];
        return dataStr;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return Boolean.parseBoolean(this.sqlGateResultPo.getDataCurRow()[columnIndex - 1]);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.sqlGateResultPo.getDataCurRow()[columnIndex - 1].getBytes()[0];
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return Short.parseShort(this.sqlGateResultPo.getDataCurRow()[columnIndex - 1]);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return Integer.parseInt(this.sqlGateResultPo.getDataCurRow()[columnIndex - 1]);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return Long.parseLong(this.sqlGateResultPo.getDataCurRow()[columnIndex - 1]);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return Float.parseFloat(this.sqlGateResultPo.getDataCurRow()[columnIndex - 1]);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return Double.parseDouble(this.sqlGateResultPo.getDataCurRow()[columnIndex - 1]);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return new BigDecimal(this.sqlGateResultPo.getDataCurRow()[columnIndex - 1]);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.sqlGateResultPo.getDataCurRow()[columnIndex - 1].getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return new Date(DateUtil.objToDate((Object)this.sqlGateResultPo.getDataCurRow()[columnIndex - 1]).getTime());
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return new Time(DateUtil.objToDate((Object)this.sqlGateResultPo.getDataCurRow()[columnIndex - 1]).getTime());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return new Timestamp(DateUtil.objToDate((Object)this.sqlGateResultPo.getDataCurRow()[columnIndex - 1]).getTime());
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSet#getAsciiStream is not supported");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSet#getUnicodeStream is not supported");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSet#getBinaryStream is not supported");
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        int indexOf = ArrayUtils.indexOf((Object[])this.sqlGateResultPo.getColNames(), (Object)columnLabel);
        return this.getString(indexOf + 1);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        int indexOf = ArrayUtils.indexOf((Object[])this.sqlGateResultPo.getColNames(), (Object)columnLabel);
        return this.getBoolean(indexOf + 1);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        int indexOf = ArrayUtils.indexOf((Object[])this.sqlGateResultPo.getColNames(), (Object)columnLabel);
        return this.getByte(indexOf + 1);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        int indexOf = ArrayUtils.indexOf((Object[])this.sqlGateResultPo.getColNames(), (Object)columnLabel);
        return this.getShort(indexOf + 1);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        int indexOf = ArrayUtils.indexOf((Object[])this.sqlGateResultPo.getColNames(), (Object)columnLabel);
        return this.getInt(indexOf + 1);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        int indexOf = ArrayUtils.indexOf((Object[])this.sqlGateResultPo.getColNames(), (Object)columnLabel);
        return this.getLong(indexOf + 1);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        int indexOf = ArrayUtils.indexOf((Object[])this.sqlGateResultPo.getColNames(), (Object)columnLabel);
        return this.getFloat(indexOf + 1);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        int indexOf = ArrayUtils.indexOf((Object[])this.sqlGateResultPo.getColNames(), (Object)columnLabel);
        return this.getDouble(indexOf + 1);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        int indexOf = ArrayUtils.indexOf((Object[])this.sqlGateResultPo.getColNames(), (Object)columnLabel);
        return this.getBigDecimal(indexOf + 1);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        int indexOf = ArrayUtils.indexOf((Object[])this.sqlGateResultPo.getColNames(), (Object)columnLabel);
        return this.getBytes(indexOf + 1);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        int indexOf = ArrayUtils.indexOf((Object[])this.sqlGateResultPo.getColNames(), (Object)columnLabel);
        return this.getDate(indexOf + 1);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        int indexOf = ArrayUtils.indexOf((Object[])this.sqlGateResultPo.getColNames(), (Object)columnLabel);
        return this.getTime(indexOf + 1);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        int indexOf = ArrayUtils.indexOf((Object[])this.sqlGateResultPo.getColNames(), (Object)columnLabel);
        return this.getTimestamp(indexOf + 1);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        int indexOf = ArrayUtils.indexOf((Object[])this.sqlGateResultPo.getColNames(), (Object)columnLabel);
        return this.getAsciiStream(indexOf + 1);
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        int indexOf = ArrayUtils.indexOf((Object[])this.sqlGateResultPo.getColNames(), (Object)columnLabel);
        return this.getUnicodeStream(indexOf + 1);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        int indexOf = ArrayUtils.indexOf((Object[])this.sqlGateResultPo.getColNames(), (Object)columnLabel);
        return this.getBinaryStream(indexOf + 1);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new FlinkResultSetMetaData(this.sqlGateResultPo.getCols());
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        String dataStr = this.sqlGateResultPo.getDataCurRow()[columnIndex - 1];
        return dataStr;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        int indexOf = ArrayUtils.indexOf((Object[])this.sqlGateResultPo.getColNames(), (Object)columnLabel);
        return indexOf + 1;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkConnection#getCharacterStream is not supported");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkConnection#getCharacterStream is not supported");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.sqlGateResultPo.getCursor() == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.sqlGateResultPo.getCursor() >= this.sqlGateResultPo.getCurData().size();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.sqlGateResultPo.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.sqlGateResultPo.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        return false;
    }

    @Override
    public int getRow() throws SQLException {
        return this.sqlGateResultPo.getCursor() + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        return 0;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
    }

    @Override
    public void insertRow() throws SQLException {
    }

    @Override
    public void updateRow() throws SQLException {
    }

    @Override
    public void deleteRow() throws SQLException {
    }

    @Override
    public void refreshRow() throws SQLException {
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
    }

    @Override
    public void moveToInsertRow() throws SQLException {
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return null;
    }
}

