/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.sqlgateway.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.List;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.apiext.jdbc.JdbcData;
import net.wicp.tams.common.apiext.jdbc.JdbcDatas;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.apiext.jdbc.OptType;
import net.wicp.tams.common.constant.dbType.BinlogType;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.flink.sqlgateway.jdbc.FlinkConnection;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FinkJdbcAssit {
    private static final Logger log = LoggerFactory.getLogger(FinkJdbcAssit.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result execSql(String jdbcUrl, String ... sqls) {
        FlinkConnection flinkConnection = null;
        Result execSql = null;
        try {
            String sql;
            flinkConnection = new FlinkConnection(jdbcUrl);
            String[] stringArray = sqls;
            int n = stringArray.length;
            for (int i = 0; i < n && (execSql = JdbcAssit.execSql((Connection)flinkConnection, (String)(sql = stringArray[i]))).isSuc(); ++i) {
            }
        }
        catch (Exception e) {
            try {
                log.error("\u6267\u884c\u7ed3\u679c\u5931\u8d25:", (Throwable)e);
                execSql = Result.getError((String)e.getMessage());
            }
            catch (Throwable throwable) {
                JdbcAssit.close(flinkConnection);
                throw throwable;
            }
            JdbcAssit.close((Connection)flinkConnection);
        }
        JdbcAssit.close((Connection)flinkConnection);
        return execSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet querySql(String jdbcUrl, String sql) {
        FlinkConnection flinkConnection = null;
        ResultSet execSql = null;
        try {
            flinkConnection = new FlinkConnection(jdbcUrl);
            execSql = JdbcAssit.querySql((Connection)flinkConnection, (String)sql);
        }
        catch (Exception e) {
            try {
                log.error("\u67e5\u8be2\u7ed3\u679c\u5931\u8d25:", (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcAssit.close(flinkConnection);
                throw throwable;
            }
            JdbcAssit.close((Connection)flinkConnection);
        }
        JdbcAssit.close((Connection)flinkConnection);
        return execSql;
    }

    public static Result dataChange(Connection conn, JdbcDatas datas, boolean logicDel) {
        if (datas.getOptType() == OptType.delete && !logicDel) {
            List datasList = datas.getDatasList();
            Object[][] datasInput = new Object[datasList.size()][];
            for (int i = 0; i < datasList.size(); ++i) {
                JdbcData jdbcData = (JdbcData)datasList.get(i);
                datasInput[i] = new Object[datas.getKeysCount()];
                for (int j = 0; j < datas.getKeysCount(); ++j) {
                    String value = (String)jdbcData.getValueMap().get(datas.getKeys(j));
                    BinlogType binlogType = BinlogType.valueOf((String)((String)datas.getTypeMap().get(datas.getKeys(j))));
                    Serializable value2 = BinlogType.getValue((BinlogType)binlogType, (String)value);
                    datasInput[i][j] = value2;
                }
            }
            return FinkJdbcAssit.dataDelete(conn, datas.getDb(), datas.getTb(), datasInput, (String[])datas.getKeysList().toArray((Object[])new String[datas.getKeysCount()]));
        }
        String sql = MySqlAssit.packageBatchSql((JdbcDatas)datas);
        Result result = JdbcAssit.execSql((Connection)conn, (String)sql);
        return result;
    }

    public static Result dataDelete(Connection conn, String db, String tb, Object[][] datas, String[] keys) {
        if (ArrayUtils.isEmpty((Object[])keys)) {
            keys = MySqlAssit.getPrimary((Connection)conn, (String)db, (String)tb);
        }
        if (!ArrayUtils.isEmpty((Object[])keys)) {
            String beginsql = String.format("delete from %s.%s where 1=1", db, tb);
            try {
                for (int i = 0; i < datas.length; ++i) {
                    StringBuilder builder = new StringBuilder(beginsql);
                    for (int j = 0; j < keys.length; ++j) {
                        builder.append(String.format(" and %s='%s'", keys[j], datas[i][j]));
                    }
                    JdbcAssit.execSql((Connection)conn, (String)builder.toString());
                }
                return Result.getSuc();
            }
            catch (Exception e) {
                log.error("\u901a\u8fc7\u4e3b\u952e\u5220\u9664\u5931\u8d25", (Throwable)e);
                return new Result(new ProjectException((IExcept)ExceptAll.jdbc_exec_fail, "\u901a\u8fc7\u4e3b\u952e\u5220\u9664\u5931\u8d25"));
            }
        }
        throw new ProjectExceptionRuntime((IExcept)ExceptAll.jdbc_exec_fail);
    }
}

