/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.wicp.tams.common.flink.sqlgateway.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.http.flink.SqlGateResultPo;
import net.wicp.tams.common.http.flink.SqlGateWay;

/**
 * Flink JDBC statement.beeline
 */
public class FlinkStatement implements Statement {

	private final SqlGateWay sqlGateWay;
	private final FlinkConnection flinkConnection;
	private boolean closed;
	private int fetchSize;
	private long maxRows;
	private FlinkResultSet flinkResultSet;// execQuery的结果,影响的数量也在这里拿
	protected boolean isQuery;

	public FlinkStatement(SqlGateWay sqlGateWay, FlinkConnection flinkConnection) {
		this.sqlGateWay = sqlGateWay;
		this.flinkConnection = flinkConnection;
		this.closed = false;
		this.fetchSize = 0;
		this.maxRows = 0;
	}

	@Override
	public <T> T unwrap(Class<T> iface) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean isWrapperFor(Class<?> iface) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	/***
	 * 注意：select在flink里拿到的结果不一定正确，sqlgate接口这块非常不稳定
	 */
	@Override
	public ResultSet executeQuery(String sql) throws SQLException {
		checkClosed();
		if (!JdbcAssit.isQuery(sql)) {
			throw new SQLException("此方法只接受查询的SQL");
		}
//		this.isQuery = true;
		this.flinkResultSet = null;
		execute(sql);
		return this.flinkResultSet;
	}

//	{
//		"nextResultUri": "/v1/sessions/a0c81860-0ca4-4cb8-a632-eee23ae17547/operations/beb8c87a-cf5e-4f33-85ff-e19095169194/result/1",
//		"results": {
//			"data": [{
//				"kind": "INSERT",
//				"fields": ["OK"]
//			}],
//			"columns": [{
//				"logicalType": {
//					"nullable": true,
//					"length": 2147483647,
//					"type": "VARCHAR"
//				},
//				"name": "result"
//			}]
//		},
//		"resultType": "PAYLOAD"
//	}
	@Override
	public int executeUpdate(String sql) throws SQLException {
		checkClosed();
		if (JdbcAssit.isQuery(sql)) {
			throw new SQLException("此方法只接受非查询的SQL");
		}
//		this.isQuery = false;
		this.flinkResultSet = null;
		execute(sql);
		String[] simpleData = this.flinkResultSet.getSqlGateResultPo().getSimpleData();
		if ("OK".equals(simpleData[0])) {
			return 0;
		}
		return 0;
	}

	@Override
	public void close() throws SQLException {
		if (closed) {
			return;
		}
		cancel();
		closed = true;
	}

	@Override
	public int getMaxFieldSize() throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#getMaxFieldSize is not supported");
	}

	@Override
	public void setMaxFieldSize(int max) throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#setMaxFieldSize is not supported");
	}

	@Override
	public int getMaxRows() throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#getMaxRows is not supported");
	}

	@Override
	public void setMaxRows(int max) throws SQLException {
		setLargeMaxRows(max);
	}

	@Override
	public void setLargeMaxRows(long max) throws SQLException {
		checkClosed();
		if (max < 0) {
			throw new SQLException("Max rows must not be negative.");
		}
		this.maxRows = max;
	}

	@Override
	public void setEscapeProcessing(boolean enable) throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#setEscapeProcessing is not supported");
	}

	@Override
	public int getQueryTimeout() throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#getQueryTimeout is not supported");
	}

	@Override
	public void setQueryTimeout(int seconds) throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#setQueryTimeout is not supported");
	}

	@Override
	public void cancel() throws SQLException {
		// 取消一个statement，如果整个statement被外层包裹可以使用（如：实现队列statement）
	}

	@Override
	public SQLWarning getWarnings() throws SQLException {
		return null;
	}

	@Override
	public void clearWarnings() throws SQLException {

	}

	@Override
	public void setCursorName(String name) throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#setCursorName is not supported");
	}

	// true:是查询，false:不是查询
	@Override
	public boolean execute(String sql) throws SQLException {
		checkClosed();
		this.flinkResultSet = new FlinkResultSet(this.sqlGateWay, sql, isSelect(sql));// 调用查询
		SqlGateResultPo resultPo = this.flinkResultSet.getSqlGateResultPo();
		if (!resultPo.isSuc()) {
			throw new SQLException(resultPo.getErrors());
		}
		this.isQuery = JdbcAssit.isQuery(sql);
		return this.isQuery;
	}

	/***
	 * select语句需要延时
	 * 
	 * @param sql
	 * @return
	 */
	private static boolean isSelect(String sql) {
		String sqlTrim = StringUtil.trimSpace(sql);
		int indexOf = sqlTrim.indexOf(" ");
		boolean retobj =indexOf<0?false:"SELECT".equalsIgnoreCase(sqlTrim.substring(0, indexOf));
		return retobj;
	}

	@Override
	public ResultSet getResultSet() throws SQLException {
		checkClosed();
		return this.flinkResultSet;
	}

	@Override
	public int getUpdateCount() throws SQLException {
		checkClosed();
		try {
			String resultColData = this.flinkResultSet.getSqlGateResultPo().getResultColData();
			return Integer.parseInt(resultColData);
		} catch (Throwable e) {
			throw new SQLException("Current result is not an update count.");
		}
	}

	@Override
	public boolean getMoreResults() throws SQLException {
		return this.isQuery;
	}

	@Override
	public void setFetchDirection(int direction) throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#setFetchDirection is not supported");
	}

	@Override
	public int getFetchDirection() throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#getFetchDirection is not supported");
	}

	@Override
	public void setFetchSize(int rows) throws SQLException {
		checkClosed();
		if (rows < 0) {
			throw new SQLException("Fetch size must not be negative.");
		}
		fetchSize = rows;
	}

	@Override
	public int getFetchSize() throws SQLException {
		checkClosed();
		return fetchSize;
	}

	@Override
	public int getResultSetConcurrency() throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#getResultSetConcurrency is not supported");
	}

	@Override
	public int getResultSetType() throws SQLException {
		return ResultSet.TYPE_FORWARD_ONLY;
	}

	@Override
	public void addBatch(String sql) throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#addBatch is not supported");
	}

	@Override
	public void clearBatch() throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#clearBatch is not supported");
	}

	@Override
	public int[] executeBatch() throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#executeBatch is not supported");
	}

	@Override
	public Connection getConnection() throws SQLException {
		return this.flinkConnection;
	}

	@Override
	public boolean getMoreResults(int current) throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#getMoreResults is not supported");
	}

	@Override
	public ResultSet getGeneratedKeys() throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#getGeneratedKeys is not supported");
	}

	@Override
	public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
		return (int) executeLargeUpdate(sql, autoGeneratedKeys);
	}

	@Override
	public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
		return (int) executeLargeUpdate(sql, columnIndexes);
	}

	@Override
	public int executeUpdate(String sql, String[] columnNames) throws SQLException {
		return (int) executeLargeUpdate(sql, columnNames);
	}

	@Override
	public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#execute is not supported");
	}

	@Override
	public boolean execute(String sql, int[] columnIndexes) throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#execute is not supported");
	}

	@Override
	public boolean execute(String sql, String[] columnNames) throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#execute is not supported");
	}

	@Override
	public int getResultSetHoldability() throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#getResultSetHoldability is not supported");
	}

	@Override
	public boolean isClosed() throws SQLException {
		return closed;
	}

	@Override
	public void setPoolable(boolean poolable) throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#setPoolable is not supported");
	}

	@Override
	public boolean isPoolable() throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#isPoolable is not supported");
	}

	@Override
	public void closeOnCompletion() throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#closeOnCompletion is not supported");
	}

	@Override
	public boolean isCloseOnCompletion() throws SQLException {
		throw new SQLFeatureNotSupportedException("FlinkStatement#isCloseOnCompletion is not supported");
	}

	protected void checkClosed() throws SQLException {
		if (closed) {
			throw new SQLException("This result set is already closed");
		}
	}

}
