/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.sqlgateway.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.flink.sqlgateway.jdbc.FlinkConnection;
import net.wicp.tams.common.flink.sqlgateway.jdbc.FlinkResultSet;
import net.wicp.tams.common.http.flink.SqlGateResultPo;
import net.wicp.tams.common.http.flink.SqlGateWay;

public class FlinkStatement
implements Statement {
    private final SqlGateWay sqlGateWay;
    private final FlinkConnection flinkConnection;
    private boolean closed;
    private int fetchSize;
    private long maxRows;
    private FlinkResultSet flinkResultSet;
    protected boolean isQuery;

    public FlinkStatement(SqlGateWay sqlGateWay, FlinkConnection flinkConnection) {
        this.sqlGateWay = sqlGateWay;
        this.flinkConnection = flinkConnection;
        this.closed = false;
        this.fetchSize = 0;
        this.maxRows = 0L;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        if (!JdbcAssit.isQuery((String)sql)) {
            throw new SQLException("\u6b64\u65b9\u6cd5\u53ea\u63a5\u53d7\u67e5\u8be2\u7684SQL");
        }
        this.flinkResultSet = null;
        this.execute(sql);
        return this.flinkResultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkClosed();
        if (JdbcAssit.isQuery((String)sql)) {
            throw new SQLException("\u6b64\u65b9\u6cd5\u53ea\u63a5\u53d7\u975e\u67e5\u8be2\u7684SQL");
        }
        this.flinkResultSet = null;
        this.execute(sql);
        String[] simpleData = this.flinkResultSet.getSqlGateResultPo().getSimpleData();
        if ("OK".equals(simpleData[0])) {
            return 0;
        }
        return 0;
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.cancel();
        this.closed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#getMaxFieldSize is not supported");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#setMaxFieldSize is not supported");
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#getMaxRows is not supported");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.checkClosed();
        if (max < 0L) {
            throw new SQLException("Max rows must not be negative.");
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#setEscapeProcessing is not supported");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#getQueryTimeout is not supported");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#setQueryTimeout is not supported");
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#setCursorName is not supported");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        this.flinkResultSet = new FlinkResultSet(this.sqlGateWay, sql, FlinkStatement.isSelect(sql));
        SqlGateResultPo resultPo = this.flinkResultSet.getSqlGateResultPo();
        if (!resultPo.isSuc()) {
            throw new SQLException(resultPo.getErrors());
        }
        this.isQuery = JdbcAssit.isQuery((String)sql);
        return this.isQuery;
    }

    private static boolean isSelect(String sql) {
        String sqlTrim = StringUtil.trimSpace((String)sql);
        int indexOf = sqlTrim.indexOf(" ");
        boolean retobj = indexOf < 0 ? false : "SELECT".equalsIgnoreCase(sqlTrim.substring(0, indexOf));
        return retobj;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.flinkResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        try {
            String resultColData = this.flinkResultSet.getSqlGateResultPo().getResultColData();
            return Integer.parseInt(resultColData);
        }
        catch (Throwable e) {
            throw new SQLException("Current result is not an update count.");
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.isQuery;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#setFetchDirection is not supported");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#getFetchDirection is not supported");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw new SQLException("Fetch size must not be negative.");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#getResultSetConcurrency is not supported");
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#addBatch is not supported");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#clearBatch is not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#executeBatch is not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.flinkConnection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#getMoreResults is not supported");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#getGeneratedKeys is not supported");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return (int)this.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return (int)this.executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return (int)this.executeLargeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#execute is not supported");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#execute is not supported");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#execute is not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#getResultSetHoldability is not supported");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#setPoolable is not supported");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#isPoolable is not supported");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#closeOnCompletion is not supported");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkStatement#isCloseOnCompletion is not supported");
    }

    protected void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("This result set is already closed");
        }
    }
}

