/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.sqlgateway.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import net.wicp.tams.common.http.flink.SqlGateResultCol;

public class FlinkResultSetMetaData
implements ResultSetMetaData {
    private final List<SqlGateResultCol> columns;

    public FlinkResultSetMetaData(List<SqlGateResultCol> columns) {
        this.columns = columns;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columns.size();
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.checkIndexBound(column);
        return true;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.checkIndexBound(column);
        return this.columns.get(column - 1).isLogicalNullable() ? 1 : 0;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.checkIndexBound(column);
        return 255;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.checkIndexBound(column);
        return this.columns.get(column - 1).getName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.checkIndexBound(column);
        return 18;
    }

    @Override
    public int getScale(int column) throws SQLException {
        this.checkIndexBound(column);
        return 2;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#getColumnType is not supported");
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.checkIndexBound(column);
        return this.columns.get(column - 1).getLogicalType();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#getColumnClassName is not supported");
    }

    private void checkIndexBound(int column) throws SQLException {
        int columnNum = this.columns.size();
        if (column <= 0) {
            throw new SQLException("Column index must be positive.");
        }
        if (column > columnNum) {
            throw new SQLException("Column index " + column + " out of bound. There are only " + columnNum + " columns.");
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#unwrap is not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#isWrapperFor is not supported");
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#isAutoIncrement is not supported");
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#isCaseSensitive is not supported");
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#isCurrency is not supported");
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#isSigned is not supported");
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.checkIndexBound(column);
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#getSchemaName is not supported");
    }

    @Override
    public String getTableName(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#getTableName is not supported");
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#getCatalogName is not supported");
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#isReadOnly is not supported");
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#isWritable is not supported");
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSetMetaData#isDefinitelyWritable is not supported");
    }
}

