package net.wicp.tams.common.flink.sqlgateway.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.List;

import org.apache.commons.lang3.ArrayUtils;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.apiext.jdbc.JdbcData;
import net.wicp.tams.common.apiext.jdbc.JdbcDatas;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.apiext.jdbc.OptType;
import net.wicp.tams.common.constant.dbType.BinlogType;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

/***
 * jdbc帮助类
 * 
 * @author Andy.zhou
 *
 */
@Slf4j
public abstract class FinkJdbcAssit {
	public static Result execSql(String jdbcUrl, String... sqls) {
		Connection flinkConnection = null;
		Result execSql = null;
		try {
			flinkConnection = new FlinkConnection(jdbcUrl);
			for (String sql : sqls) {
				execSql = JdbcAssit.execSql(flinkConnection, sql);//
				if (!execSql.isSuc()) {// 没有成功就退出。
					break;
				}
			}
		} catch (Exception e) {
			log.error("执行结果失败:", e);
			execSql = Result.getError(e.getMessage());
		} finally {
			JdbcAssit.close(flinkConnection);
		}
		return execSql;
	}

	public static ResultSet querySql(String jdbcUrl, String sql) {
		Connection flinkConnection = null;
		ResultSet execSql = null;
		try {
			flinkConnection = new FlinkConnection(jdbcUrl);
			execSql = JdbcAssit.querySql(flinkConnection, sql);
		} catch (Exception e) {
			log.error("查询结果失败:", e);
		} finally {
			JdbcAssit.close(flinkConnection);
		}
		return execSql;
	}

	public static Result dataChange(Connection conn, JdbcDatas datas, boolean logicDel) {
		if (datas.getOptType() == OptType.delete && !logicDel) {// 不是逻辑删除
			List<JdbcData> datasList = datas.getDatasList();
			Object[][] datasInput = new Object[datasList.size()][];
			for (int i = 0; i < datasList.size(); i++) {
				JdbcData jdbcData = datasList.get(i);
				datasInput[i] = new Object[datas.getKeysCount()];
				for (int j = 0; j < datas.getKeysCount(); j++) {
					String value = jdbcData.getValueMap().get(datas.getKeys(j));
					BinlogType binlogType = BinlogType.valueOf(datas.getTypeMap().get(datas.getKeys(j)));
					Serializable value2 = BinlogType.getValue(binlogType, value);
					datasInput[i][j] = value2;
				}
			}
			return dataDelete(conn, datas.getDb(), datas.getTb(), datasInput,
					datas.getKeysList().toArray(new String[datas.getKeysCount()]));
		} else {
			String sql = MySqlAssit.packageBatchSql(datas);
			Result result = JdbcAssit.execSql(conn, sql);
			return result;
		}
	}

	public static Result dataDelete(Connection conn, String db, String tb, Object[][] datas, String[] keys) {
		if (ArrayUtils.isEmpty(keys)) {
			keys = MySqlAssit.getPrimary(conn, db, tb);
		}
		if (!ArrayUtils.isEmpty(keys)) {// 需要删除ID
			String beginsql = String.format("delete from %s.%s where 1=1", db, tb);
			try {
				for (int i = 0; i < datas.length; i++) {
					StringBuilder builder = new StringBuilder(beginsql);
					for (int j = 0; j < keys.length; j++) {
						builder.append(String.format(" and %s='%s'", keys[j], datas[i][j]));
					}
					JdbcAssit.execSql(conn, builder.toString());
				}
				return Result.getSuc();
			} catch (Exception e) {
				log.error("通过主键删除失败", e);
				return new Result(new ProjectException(ExceptAll.jdbc_exec_fail, "通过主键删除失败"));
			}
		} else {
			throw new ProjectExceptionRuntime(ExceptAll.jdbc_exec_fail);
		}
	}
}
