/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.sqlgateway.tams;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.common.flink.sqlgateway.jdbc.FlinkConnection;
import net.wicp.tams.common.flink.sqlgateway.jdbc.FlinkStatement;
import net.wicp.tams.common.flink.sqlgateway.tams.TamsConnection;
import net.wicp.tams.common.flink.sqlgateway.tams.TamsResultSet;
import net.wicp.tams.common.flink.sqlgateway.tams.constant.OpsCmd;
import net.wicp.tams.common.http.flink.SqlGateWay;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TamsStatement
extends FlinkStatement {
    private static final Logger log = LoggerFactory.getLogger(TamsStatement.class);
    private static String tamRule = "tams\\s+(?<subcmd>(save|show|submit|stop){1})\\s+(?<params>[a-zA-Z0-9-//:,]*)";
    private final TamsConnection tamsConnection;
    private TamsResultSet tamsResultSet;

    public TamsStatement(SqlGateWay sqlGateWay, TamsConnection flinkConnection) {
        super(sqlGateWay, (FlinkConnection)flinkConnection);
        this.tamsConnection = flinkConnection;
    }

    public boolean execute(String sql) throws SQLException {
        log.info("=======\u4f7f\u7528execute Tams=========");
        Triple<Boolean, Boolean, String> checkSql = this.checkSql(sql);
        boolean isQuery = (Boolean)checkSql.getLeft();
        if (isQuery) {
            if (((Boolean)checkSql.getMiddle()).booleanValue()) {
                this.executeTams((String)checkSql.getRight());
            } else {
                super.execute((String)checkSql.getRight());
            }
        } else if (((Boolean)checkSql.getMiddle()).booleanValue()) {
            this.executeUpdate((String)checkSql.getRight());
        } else {
            super.execute((String)checkSql.getRight());
        }
        return isQuery;
    }

    public boolean executeTams(String sql) throws SQLException {
        super.checkClosed();
        String[] group = StrPattern.group((String)tamRule, (String)sql, (String[])new String[]{"subcmd", "params"});
        OpsCmd opsCmd = this.chekCmd(group);
        Result httpResult = opsCmd.call(this.tamsConnection.getTenantId(), this.tamsConnection.getOperateId(), this.tamsConnection.getPwd(), this.tamsConnection.getOpsUrl(), group[1], JsonNodeFactory.instance.objectNode(), new String[0]);
        if (!httpResult.isSuc()) {
            throw new SQLException(httpResult.getMessage());
        }
        ArrayNode data = (ArrayNode)httpResult.retObjs(0);
        this.tamsResultSet = new TamsResultSet(data, new String[]{"id", "name"});
        this.isQuery = true;
        return this.isQuery;
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.tamsResultSet == null ? super.getResultSet() : this.tamsResultSet;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        super.checkClosed();
        Triple<Boolean, Boolean, String> checkSql = this.checkSql(sql);
        if (!((Boolean)checkSql.getLeft()).booleanValue()) {
            throw new SQLException("\u6b64\u65b9\u6cd5\u53ea\u63a5\u53d7\u67e5\u8be2\u7684SQL");
        }
        this.tamsResultSet = null;
        this.execute(sql);
        return this.getResultSet();
    }

    private Triple<Boolean, Boolean, String> checkSql(String sql) throws SQLException {
        boolean isQuery = true;
        String retsql = StringUtil.trimSpace((String)sql).replaceAll("\r\n", "\n");
        boolean isTams = retsql.startsWith(OpsCmd.tamsSqlFlag);
        if (isTams) {
            String[] group = StrPattern.group((String)tamRule, (String)sql, (String[])new String[]{"subcmd", "params"});
            OpsCmd opsCmd = this.chekCmd(group);
            isQuery = opsCmd.isQuery();
        } else {
            isQuery = JdbcAssit.isQuery((String)sql);
        }
        return Triple.of((Object)isQuery, (Object)isTams, (Object)retsql);
    }

    public int executeUpdate(String sql) throws SQLException {
        super.checkClosed();
        log.info("=======\u4f7f\u7528executeUpdate Tams=========");
        String sqlTrue = StringUtil.trimSpace((String)sql).replaceAll("\r\n", "\n");
        if (sqlTrue.startsWith(OpsCmd.tamsSqlFlag)) {
            Result httpResult;
            int lineIndex = sqlTrue.indexOf("\n");
            String saveSql = null;
            String cmdSql = null;
            if (lineIndex > 0) {
                saveSql = sqlTrue.substring(lineIndex + 1);
                cmdSql = sqlTrue.substring(0, lineIndex);
            } else {
                cmdSql = sqlTrue;
            }
            String[] group = StrPattern.group((String)tamRule, (String)cmdSql, (String[])new String[]{"subcmd", "params"});
            OpsCmd opsCmd = this.chekCmd(group);
            ArrayList<String> paramslist = new ArrayList<String>();
            String subCmd = null;
            if (group[1].contains(":")) {
                String[] args;
                for (String arg : args = group[1].split(",")) {
                    String[] argsinglevalue = arg.split(":");
                    paramslist.add(argsinglevalue[0]);
                    paramslist.add(argsinglevalue[1]);
                }
            } else {
                subCmd = group[1];
            }
            ObjectNode parmas = JsonNodeFactory.instance.objectNode();
            if (StringUtil.isNotNull((Object)saveSql)) {
                String saveSqlTrue = StringUtil.trimSpace((String)saveSql);
                saveSqlTrue = saveSqlTrue.endsWith(";") ? saveSqlTrue : saveSqlTrue + ";";
                parmas.put("mainArgs", saveSqlTrue);
            }
            if (!(httpResult = opsCmd.call(this.tamsConnection.getTenantId(), this.tamsConnection.getOperateId(), this.tamsConnection.getPwd(), this.tamsConnection.getOpsUrl(), subCmd, parmas, paramslist.toArray(new String[paramslist.size()]))).isSuc()) {
                throw new SQLException(httpResult.getMessage());
            }
            return 0;
        }
        return super.executeUpdate(sqlTrue);
    }

    private OpsCmd chekCmd(String[] group) throws SQLException {
        if (group.length != 2 || StringUtil.isNull((Object)group[0]) || StringUtil.isNull((Object)group[1])) {
            throw new SQLException("\u53c2\u6570\u9519\u8bef\uff0ctams\u547d\u4ee4\u793a\u4f8b\uff1atams save slot:1,config:1\u6216tams submit|drop abc");
        }
        OpsCmd opsCmd = OpsCmd.find(group[0]);
        if (opsCmd == null) {
            throw new SQLException("\u4e0d\u652f\u6301\u7684\u547d\u4ee4\u3010" + group[0] + "\u3011\uff0ctams\u652f\u6301\u7684\u547d\u4ee4\u6709\uff1a" + OpsCmd.values());
        }
        return opsCmd;
    }
}

