/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.sqlgateway.tams;

import java.sql.SQLException;
import java.sql.Statement;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.flink.sqlgateway.jdbc.FlinkConnection;
import net.wicp.tams.common.flink.sqlgateway.tams.TamsStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TamsConnection
extends FlinkConnection {
    private static final Logger log = LoggerFactory.getLogger(TamsConnection.class);
    private final long tenantId;
    private final long operateId;
    private final String pwd;
    private final String opsUrl;

    public TamsConnection(String jdbcUrl) throws Exception {
        super(jdbcUrl.replace(":tams:", ":flink:"));
        String[] params = this.getParams();
        YesOrNo https = YesOrNo.yes;
        String domain = null;
        String tenantIdStr = null;
        String operateIdStr = null;
        String pwdStr = null;
        block14: for (String param : params) {
            String[] paramValAry = param.split("=");
            switch (paramValAry[0]) {
                case "https": {
                    https = YesOrNo.find((String)paramValAry[1]);
                    continue block14;
                }
                case "domain": {
                    domain = paramValAry[1];
                    continue block14;
                }
                case "tenantId": {
                    tenantIdStr = paramValAry[1];
                    continue block14;
                }
                case "operateId": {
                    operateIdStr = paramValAry[1];
                    continue block14;
                }
                case "pwd": {
                    pwdStr = paramValAry[1];
                    continue block14;
                }
            }
        }
        if (StringUtil.isNull(tenantIdStr)) {
            throw new Exception("\u9700\u8981\u53c2\u6570\uff1atenantId");
        }
        this.tenantId = Long.parseLong(tenantIdStr);
        if (StringUtil.isNull(operateIdStr)) {
            throw new Exception("\u9700\u8981\u53c2\u6570\uff1aoperateId");
        }
        this.operateId = Long.parseLong(operateIdStr);
        if (StringUtil.isNull(pwdStr)) {
            throw new Exception("\u9700\u8981\u53c2\u6570\uff1apwd");
        }
        this.pwd = pwdStr;
        if (StringUtil.isNull(domain)) {
            throw new Exception("\u9700\u8981\u53c2\u6570\uff1adomain");
        }
        this.opsUrl = String.format("%s://%s", https == YesOrNo.yes ? "https" : "http", domain);
        log.info("=======\u4f7f\u7528jdbc Tams\u8fde\u63a5=========");
    }

    public Statement createStatement() throws SQLException {
        log.info("=======\u4f7f\u7528Statement Tams=========");
        return new TamsStatement(this.getSqlGateWay(), this);
    }

    public long getTenantId() {
        return this.tenantId;
    }

    public long getOperateId() {
        return this.operateId;
    }

    public String getOpsUrl() {
        return this.opsUrl;
    }

    protected String getPwd() {
        return this.pwd;
    }
}

