/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.sqlgateway.tams.constant;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

import com.esotericsoftware.kryo.util.ObjectMap;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.http.HttpClient;
import net.wicp.tams.common.http.HttpResult;
import net.wicp.tams.common.http.IHttpResultParser;

/***
 * 支持ops的cmd
 * 
 * @author andy.zhou
 * 
 */
public enum OpsCmd implements IEnumCombobox {
	save("保存flinksql任务", false, null, new String[] { "/moudle/tamsMoudleFlink/flinkSql:save" }), /// moudle/tamsMoudleFlink/rest/Flinksql:saveFlinkSql

	submit("提交flinksql任务", false, "name", new String[] { "/moudle/tamsMoudleFlink/flinkSql:submitTaskByName" }),

	stop("卸载flinksql任务", false, "name", new String[] { "/moudle/tamsMoudleFlink/flinkSql:unInstallByName" }),

	show("显示元数据", true, null,
			new String[] { "flinksql", "/moudle/tamsMoudleFlink/flinkSql:queryList?text=name&value=id" })

	;

	private final String desc;

	private final boolean isQuery;

	private final String subCmdAsParamName;// 这个定义把cmd命令做为参数的名称

	public boolean isQuery() {
		return isQuery;
	}

	private final String[] subCmdOpsRelaUrl;

	public static String tamsSqlFlag = "tams";

	// 得到的调用参数
	public String getOpsUrl(String opsUrl, String subCmd, String... params) {
		String relaUrl = null;
		if (StringUtil.isNull(subCmd) || StringUtil.isNotNull(subCmdAsParamName)) {
			relaUrl = this.subCmdOpsRelaUrl[0];
		} else {
			int indexOf = ArrayUtils.indexOf(this.subCmdOpsRelaUrl, subCmd);
			if (indexOf < 0) {
				throw new ProjectExceptionRuntime(ExceptAll.param_error, "此子命令不支持：[" + subCmd + "]");
			} else {
				relaUrl = this.subCmdOpsRelaUrl[indexOf + 1];
			}
		}
		String returl = StringUtil.packageUrlParams(IOUtil.mergeFolderAndFilePath(opsUrl, relaUrl), params);
		return returl;
	}

	/***
	 * 
	 * @param tenantId  ops租户id
	 * @param operateId ops用户id
	 * @param pwd       ops密码
	 * @param opsUrl    ops地址
	 * @param subCmd    子命令
	 * @param dataobj   form形式提交的参数
	 * @param params    url形式提交的参数
	 * @return
	 */
	public Result call(long tenantId, long operateId, String pwd, String opsUrl, String subCmd, ObjectNode dataobj,
			String... params)  {
		List<Header> headerlist = new ArrayList<>();
		headerlist.add(new BasicHeader("tenantId", String.valueOf(tenantId)));
		headerlist.add(new BasicHeader("userId", String.valueOf(operateId)));
		headerlist.add(new BasicHeader("pwd", pwd));
		headerlist.add(new BasicHeader("forceFresh", "false"));
		String[] paramsTrue =StringUtil.isNotNull(subCmdAsParamName)?ArrayUtils.addAll(params, subCmdAsParamName,subCmd):params;
		String opsUrlTrue = getOpsUrl(opsUrl, subCmd, paramsTrue);
		Map treeToValue;
		try {
			treeToValue = new ObjectMapper().treeToValue(dataobj, Map.class);
		} catch (Exception e) {
			throw new ProjectExceptionRuntime(ExceptAll.Project_default, e);
		} 
		HttpResult doPost = HttpClient.doPostForm(opsUrlTrue, treeToValue,
				headerlist.toArray(new Header[headerlist.size()]));
		return doPost.getResult(new IHttpResultParser() {
			@Override
			public Result getObj(String value) {
				if (StringUtil.isNull(value)) {
					return Result.getError("调用失败，请测试此地址：" + opsUrlTrue);
				} else {
					if (isQuery) {
						try {
							ArrayNode array =   JSONUtil.parserStr(new ObjectMapper(), value);
							Result suc = Result.getSuc();
							suc.setRetObjs(array);
							return suc;
						} catch (Exception e) {
							return Result.getError(value);
						}
					} else {
						return Result.getFromResultJson(value);
					}
				}
			}
		});
	}

	private OpsCmd(String desc, boolean isQuery, String subCmdAsParamName, String[] subCmdOpsRelaUrl) {
		this.desc = desc;
		this.isQuery = isQuery;
		this.subCmdAsParamName = subCmdAsParamName;
		this.subCmdOpsRelaUrl = subCmdOpsRelaUrl;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public static OpsCmd find(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (OpsCmd ele : OpsCmd.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}
}
