package net.wicp.tams.common.flink.sqlgateway.tams;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.tuple.Triple;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.common.flink.sqlgateway.jdbc.FlinkStatement;
import net.wicp.tams.common.flink.sqlgateway.tams.constant.OpsCmd;
import net.wicp.tams.common.http.flink.SqlGateWay;

@Slf4j
public class TamsStatement extends FlinkStatement {

	private static String tamRule = "tams\\s+(?<subcmd>(save|show|submit|stop){1})\\s+(?<params>[a-zA-Z0-9-//:,]*)"; // "tams
																											// save
																											// slot:1,config:1"

	private final TamsConnection tamsConnection;// 连接的引用

	private TamsResultSet tamsResultSet;

	public TamsStatement(SqlGateWay sqlGateWay, TamsConnection flinkConnection) {
		super(sqlGateWay, flinkConnection);
		this.tamsConnection = flinkConnection;
	}

	// true:是查询，false:不是查询
	@Override
	public boolean execute(String sql) throws SQLException {
		log.info("=======使用execute Tams=========");
		Triple<Boolean, Boolean, String> checkSql = checkSql(sql);
		boolean isQuery = checkSql.getLeft().booleanValue();
		if (isQuery) {
			if (checkSql.getMiddle().booleanValue()) {
				this.executeTams(checkSql.getRight());
			} else {
				super.execute(checkSql.getRight());
			}
		} else {
			if (checkSql.getMiddle().booleanValue()) {
				this.executeUpdate(checkSql.getRight());
			} else {
				super.execute(checkSql.getRight());// 这里使用executeUpdate会死循环
			}
		}
		return isQuery;
	}

	public boolean executeTams(String sql) throws SQLException {
		super.checkClosed();
		String[] group = StrPattern.group(tamRule, sql, new String[] { "subcmd", "params" });
		OpsCmd opsCmd = chekCmd(group);
		// 调接口
		Result httpResult = opsCmd.call(tamsConnection.getTenantId(), tamsConnection.getOperateId(),
				tamsConnection.getPwd(), tamsConnection.getOpsUrl(), group[1],JsonNodeFactory.instance.objectNode());
		if (!httpResult.isSuc()) {
			throw new SQLException(httpResult.getMessage());
		}
		ArrayNode data = (ArrayNode) httpResult.retObjs(0);
		this.tamsResultSet = new TamsResultSet(data, new String[] { "id", "name" });// 调用查询
		super.isQuery = true;
		return super.isQuery;
	}

	@Override
	public ResultSet getResultSet() throws SQLException {
		checkClosed();
		return this.tamsResultSet == null ? super.getResultSet() : this.tamsResultSet;
	}

	@Override
	public ResultSet executeQuery(String sql) throws SQLException {
		super.checkClosed();
		Triple<Boolean, Boolean, String> checkSql = checkSql(sql);
		if (!checkSql.getLeft().booleanValue()) {
			throw new SQLException("此方法只接受查询的SQL");
		}
		this.tamsResultSet = null;
		execute(sql);
		return getResultSet();
	}

	/***
	 * L:是否查询 M：是tamssql R:转换后的SQL
	 * 
	 * @param sql
	 * @return
	 * @throws SQLException
	 */
	private Triple<Boolean, Boolean, String> checkSql(String sql) throws SQLException {
		boolean isQuery = true;
		String retsql = StringUtil.trimSpace(sql).replaceAll("\r\n", "\n");
		boolean isTams = retsql.startsWith(OpsCmd.tamsSqlFlag);
		if (isTams) {
			String[] group = StrPattern.group(tamRule, sql, new String[] { "subcmd", "params" });
			OpsCmd opsCmd = chekCmd(group);
			isQuery = opsCmd.isQuery();
			// if (!opsCmd.isQuery()) {
			// throw new SQLException("此方法只接受查询的SQL");
			// }
		} else {
			isQuery = JdbcAssit.isQuery(sql);
			// if (!JdbcAssit.isQuery(sql)) {
			// throw new SQLException("此方法只接受查询的SQL");
			// }
		}
		return Triple.of(isQuery, isTams, retsql);
	}

	@Override
	public int executeUpdate(String sql) throws SQLException {
		super.checkClosed();
		log.info("=======使用executeUpdate Tams=========");
		String sqlTrue = StringUtil.trimSpace(sql).replaceAll("\r\n", "\n");
		if (sqlTrue.startsWith(OpsCmd.tamsSqlFlag)) {
			int lineIndex = sqlTrue.indexOf("\n");
			String saveSql = null;// 保存的SQL
			String cmdSql = null;
			if (lineIndex > 0) {
				saveSql = sqlTrue.substring(lineIndex + 1);
				cmdSql = sqlTrue.substring(0, lineIndex);// 第一行是控制行。
			} else {
				cmdSql = sqlTrue;
			}
			String[] group = StrPattern.group(tamRule, cmdSql, new String[] { "subcmd", "params" });
			OpsCmd opsCmd = chekCmd(group);

			List<String> paramslist = new ArrayList<>();// 提交的参数
			String subCmd = null;
			if (group[1].contains(":")) {
				String[] args = group[1].split(",");
				for (String arg : args) {
					String[] argsinglevalue = arg.split(":");
					paramslist.add(argsinglevalue[0]);
					paramslist.add(argsinglevalue[1]);
				}
			} else {
				subCmd = group[1];
			}
//			String opsUrl = opsCmd.getOpsUrl(tamsConnection.getOpsUrl(),
//					paramslist.toArray(new String[paramslist.size()]));
			ObjectNode parmas = JsonNodeFactory.instance.objectNode();
			if (StringUtil.isNotNull(saveSql)) {// 处理mysql
				String saveSqlTrue = StringUtil.trimSpace(saveSql);
				saveSqlTrue = saveSqlTrue.endsWith(";") ? saveSqlTrue : saveSqlTrue + ";";
				parmas.put("mainArgs", saveSqlTrue);
			}
			Result httpResult = opsCmd.call(tamsConnection.getTenantId(), tamsConnection.getOperateId(),
					tamsConnection.getPwd(), tamsConnection.getOpsUrl(), subCmd, parmas,
					paramslist.toArray(new String[paramslist.size()]));
			// HttpResult httpResult = HttpClient.doPost(opsUrl, parmas);
			// Result postRs = httpResult.getResult();
			if (!httpResult.isSuc()) {
				throw new SQLException(httpResult.getMessage());
			}
			return 0;
		} else {
			return super.executeUpdate(sqlTrue);
		}
	}

	private OpsCmd chekCmd(String[] group) throws SQLException {
		if (group.length != 2 || StringUtil.isNull(group[0]) || StringUtil.isNull(group[1])) {
			throw new SQLException("参数错误，tams命令示例：tams save slot:1,config:1或tams submit|drop abc");
		}
		OpsCmd opsCmd = OpsCmd.find(group[0]);
		if (opsCmd == null) {
			throw new SQLException("不支持的命令【" + group[0] + "】，tams支持的命令有：" + OpsCmd.values());
		}
		return opsCmd;
	}

}
