package net.wicp.tams.common.flink.sqlgateway.tams;

import java.sql.SQLException;
import java.sql.Statement;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.flink.sqlgateway.jdbc.FlinkConnection;

@Slf4j
public class TamsConnection extends FlinkConnection {
	private final long tenantId;
	private final long operateId;// 用户id
	private final String pwd;// 密码
	private final String opsUrl;// 由参数https和domain组成

	public TamsConnection(String jdbcUrl) throws Exception {
		super(jdbcUrl.replace(":tams:", ":flink:"));
		String[] params = this.getParams();
		YesOrNo https = YesOrNo.yes;
		String domain = null;
		String tenantIdStr = null;
		String operateIdStr = null;
		String pwdStr = null;
		for (String param : params) {
			String[] paramValAry = param.split("=");
			switch (paramValAry[0]) {
			case "https":
				https = YesOrNo.find(paramValAry[1]);
				break;
			case "domain":
				domain = paramValAry[1];
				break;
			case "tenantId":
				tenantIdStr = paramValAry[1];
				break;
			case "operateId":
				operateIdStr = paramValAry[1];
				break;
			case "pwd":
				pwdStr = paramValAry[1];
				break;
			default:
				break;
			}
		}
		if (StringUtil.isNull(tenantIdStr)) {
			throw new Exception("需要参数：tenantId");
		} else {
			this.tenantId = Long.parseLong(tenantIdStr);
		}
		if (StringUtil.isNull(operateIdStr)) {
			throw new Exception("需要参数：operateId");
		} else {
			this.operateId = Long.parseLong(operateIdStr);
		}
		if (StringUtil.isNull(pwdStr)) {
			throw new Exception("需要参数：pwd");
		} else {
			this.pwd = pwdStr;
		}
		if (StringUtil.isNull(domain)) {
			throw new Exception("需要参数：domain");
		} else {
			this.opsUrl = String.format("%s://%s", https == YesOrNo.yes ? "https" : "http", domain);
		}
		log.info("=======使用jdbc Tams连接=========");
	}

	@Override
	public Statement createStatement() throws SQLException {
		log.info("=======使用Statement Tams=========");
		return new TamsStatement(getSqlGateWay(), this);
	}

	public long getTenantId() {
		return tenantId;
	}

	public long getOperateId() {
		return operateId;
	}

	public String getOpsUrl() {
		return opsUrl;
	}

	protected String getPwd() {
		return pwd;
	}
}
