/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.module;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.flink.common.module.IPackageEnum;
import net.wicp.tams.common.flink.common.module.IUdfEnum;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.module.Module;

public class TamsModule
implements Module {
    private static final TamsModule INSTANCE = new TamsModule();
    private final Map<IUdfEnum, FunctionDefinition> funmap = new HashMap<IUdfEnum, FunctionDefinition>();

    public static TamsModule getInstance() {
        return INSTANCE;
    }

    private TamsModule() {
        ServiceLoader<IPackageEnum> udffats = ServiceLoader.load(IPackageEnum.class);
        for (IPackageEnum udffat : udffats) {
            IUdfEnum[] udfEnums;
            for (IUdfEnum udfEnum : udfEnums = udffat.queryAll()) {
                try {
                    this.funmap.put(udfEnum, (FunctionDefinition)this.getClass().getClassLoader().loadClass(udfEnum.getClassFullName()).newInstance());
                }
                catch (Exception e) {
                    throw new ProjectExceptionRuntime((IExcept)ExceptAll.flink_udf_nodef);
                }
            }
        }
    }

    public Set<String> listFunctions() {
        return this.funmap.keySet().stream().map(IUdfEnum::getFullName).collect(Collectors.toSet());
    }

    public Optional<FunctionDefinition> getFunctionDefinition(String name) {
        return this.funmap.keySet().stream().filter(f -> f.getFullName().equalsIgnoreCase(name)).findFirst().map(udf -> this.funmap.get(udf));
    }
}

