package net.wicp.tams.common.flink.module.constant;

import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.functions.FunctionKind;

import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.flink.common.module.IUdfEnum;
import net.wicp.tams.common.flink.module.function.SubstringFunction;

/***
 * 自定义函数枚举
 * 
 * @author Andy
 *
 */
public enum UdfEnum implements IEnumCombobox, IUdfEnum {
	substring("把字符转为md5", SubstringFunction.class, FunctionKind.SCALAR,"duckula");

	private final String desc;
	private final Class<?> classz;
	private final FunctionKind kind;
	private final String defaultDbName;//默认db

	private UdfEnum(String desc, Class<?> classz, FunctionKind kind,String defaultDbName) {
		this.desc = desc;
		this.classz = classz;
		this.kind = kind;
		this.defaultDbName=defaultDbName;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public Class<?> getClassz() {
		return classz;
	}

	public FunctionKind getKind() {
		return kind;
	}

	@Override
	public String getDescription() {
		return this.desc;
	}

	public static UdfEnum find(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (UdfEnum ele : UdfEnum.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}

	@Override
	public String getClassFullName() {
		return this.classz.getName();
	}

	@Override
	public String getDbName() {
		return defaultDbName;
	}
}
