package net.wicp.tams.common.flink.module;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.module.Module;

import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.flink.common.module.IPackageEnum;
import net.wicp.tams.common.flink.common.module.IUdfEnum;

public class TamsModule implements Module {
	private static final TamsModule INSTANCE = new TamsModule();
	// private final List<FunctionDefinition> functionDefinitions;
	// private final Set<String> functionNames;

	private final Map<IUdfEnum, FunctionDefinition> funmap;

	public static TamsModule getInstance() {
		return INSTANCE;
	}

	@SuppressWarnings("rawtypes")
	private TamsModule() {
		this.funmap = new HashMap<IUdfEnum, FunctionDefinition>();
		// 只要实现了IPackageEnum接口的类都会被扫描到
		ServiceLoader<IPackageEnum> udffats = ServiceLoader.load(IPackageEnum.class);
		for (IPackageEnum udffat : udffats) {
			IUdfEnum[] udfEnums = udffat.queryAll();
			// 一个一个函数进行添加
			for (IUdfEnum udfEnum : udfEnums) {
				try {
					funmap.put(udfEnum, (FunctionDefinition)this.getClass().getClassLoader().loadClass(udfEnum.getClassFullName()).newInstance());
				} catch (Exception e) {
					throw new ProjectExceptionRuntime(ExceptAll.flink_udf_nodef);
				}
			}
		}
	}

	@Override
	public Set<String> listFunctions() {
		return funmap.keySet().stream().map(IUdfEnum::getFullName).collect(Collectors.toSet());
	}

	@Override
	public Optional<FunctionDefinition> getFunctionDefinition(String name) {
		return funmap.keySet().stream().filter(f -> f.getFullName().equalsIgnoreCase(name)).findFirst()
				.map(udf -> funmap.get(udf)); // .stream().filter().map(Function.identity());
	}
}
