/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.module.constant;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.ICallBack;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;

public enum DataTypeEnum implements IEnumCombobox
{
    BOOLEAN("boolean\u578b", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.BOOLEAN();
        }
    }),
    CHAR("CHAR", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.STRING();
        }
    }),
    VARCHAR("VARCHAR", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.STRING();
        }
    }),
    STRING("STRING", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.STRING();
        }
    }),
    BINARY("BINARY", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.BYTES();
        }
    }),
    VARBINARY("VARBINARY", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.BYTES();
        }
    }),
    BYTES("\u5b57\u8282\u7ec4\uff08BYTES\uff09", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.BYTES();
        }
    }),
    DECIMAL("DECIMAL", new ICallBack<DataType>(){

        public DataType getObj() {
            return null;
        }
    }),
    TINYINT("\u77ed\u6574\u5f62\uff08<255\uff09", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.TINYINT();
        }
    }),
    SMALLINT("\u5c0f\u6574\u578b\uff08<65535\uff09", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.SMALLINT();
        }
    }),
    INT("\u6574\u578b", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.INT();
        }
    }),
    BIGINT("\u957f\u6574\u578b", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.BIGINT();
        }
    }),
    FLOAT("\u5355\u7cbe\u5ea6\u6d6e\u70b9\u578b", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.FLOAT();
        }
    }),
    DOUBLE("\u53cc\u7cbe\u5ea6\u6d6e\u70b9\u578b", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.DOUBLE();
        }
    }),
    DATE("\u65e5\u671f", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.DATE();
        }
    }),
    TIME("\u65f6\u95f4", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.TIME();
        }
    }),
    TIMESTAMP("\u65f6\u95f4\u6233", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.TIMESTAMP();
        }
    }),
    TIMESTAMP_WITH_LOCAL_TIME_ZONE("TIMESTAMP_WITH_LOCAL_TIME_ZONE", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.TIMESTAMP();
        }
    }),
    INTERVAL_YEAR_TO_MONTH("INTERVAL_YEAR_TO_MONTH", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.INT();
        }
    }),
    INTERVAL_DAY_TO_MONTH("INTERVAL_DAY_TO_MONTH", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.BIGINT();
        }
    }),
    ROW("ROW", new ICallBack<DataType>(){

        public DataType getObj() {
            return DataTypes.ROW();
        }
    }),
    ARRAY("ARRAY", new ICallBack<DataType>(){

        public DataType getObj() {
            return null;
        }
    }),
    MAP("MAP", new ICallBack<DataType>(){

        public DataType getObj() {
            return null;
        }
    }),
    MULTISET("MULTISET", new ICallBack<DataType>(){

        public DataType getObj() {
            return null;
        }
    }),
    RAW("RAW", new ICallBack<DataType>(){

        public DataType getObj() {
            return null;
        }
    });

    private final String desc;
    private final ICallBack<DataType> convert;

    private DataTypeEnum(String desc, ICallBack<DataType> convert) {
        this.desc = desc;
        this.convert = convert;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getName() {
        return this.name();
    }

    public String getDesc_zh() {
        return this.desc;
    }

    public String getDesc_en() {
        return this.name();
    }

    public DataType getDataType() {
        return (DataType)this.convert.getObj();
    }

    public static DataTypeEnum find(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        for (DataTypeEnum ele : DataTypeEnum.values()) {
            if (!StringUtil.blankToChart((String)name, (String)"_", (boolean)true).equalsIgnoreCase(ele.name())) continue;
            return ele;
        }
        return null;
    }
}

