/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.module;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.flink.module.constant.UdfEnum;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.module.Module;

public class TamsModule
implements Module {
    private static final TamsModule INSTANCE = new TamsModule();
    private final Map<UdfEnum, FunctionDefinition> funmap = new HashMap<UdfEnum, FunctionDefinition>();

    public static TamsModule getInstance() {
        return INSTANCE;
    }

    private TamsModule() {
        for (UdfEnum udfEnum : UdfEnum.values()) {
            try {
                this.funmap.put(udfEnum, (FunctionDefinition)udfEnum.getClassz().newInstance());
            }
            catch (Exception e) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.flink_udf_nodef);
            }
        }
    }

    public Set<String> listFunctions() {
        return this.funmap.keySet().stream().map(UdfEnum::getFullName).collect(Collectors.toSet());
    }

    public Optional<FunctionDefinition> getFunctionDefinition(String name) {
        return this.funmap.keySet().stream().filter(f -> f.getFullName().equalsIgnoreCase(name)).findFirst().map(udf -> this.funmap.get(udf));
    }
}

