package net.wicp.tams.common.flink.module.constant;

import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.functions.FunctionKind;

import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.flink.module.IUdfEnum;
import net.wicp.tams.common.flink.module.TamsModuleOptions;
import net.wicp.tams.common.flink.module.function.SubstringFunction;

/***
 * 自定义函数枚举
 * 
 * @author Andy
 *
 */
public enum UdfEnum implements IEnumCombobox, IUdfEnum {
	substring("把字符转为md5", SubstringFunction.class, FunctionKind.SCALAR);

	private final String desc;
	private final Class<?> classz;
	private final FunctionKind kind;

	private UdfEnum(String desc, Class<?> classz, FunctionKind kind) {
		this.desc = desc;
		this.classz = classz;
		this.kind = kind;
	}
	

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public Class<?> getClassz() {
		return classz;
	}

	public FunctionKind getKind() {
		return kind;
	}

	@Override
	public String getDescription() {
		return this.desc;
	}

	/***
	 * 函数的最终名称,用“.”会导致语法错误
	 * 
	 * @return
	 */
	public String getFullName() {
		return String.format("%s_%s", TamsModuleOptions.IDENTIFIER, this.name());
	}

	public static UdfEnum find(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (UdfEnum ele : UdfEnum.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}
}
