package net.wicp.tams.common.flink.module.constant;

import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.ICallBack;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * 返回空值的暂不支持
 * 
 * @author Andy
 *
 */
public enum DataTypeEnum implements IEnumCombobox {
	BOOLEAN("boolean型", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.BOOLEAN();
		}
	}),

	CHAR("CHAR", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.STRING();
		}
	}),

	VARCHAR("VARCHAR", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.STRING();
		}
	}),

	STRING("STRING", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.STRING();
		}
	}),

	BINARY("BINARY", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.BYTES();
		}
	}),

	VARBINARY("VARBINARY", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.BYTES();
		}
	}),

	BYTES("字节组（BYTES）", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.BYTES();
		}
	}),

	DECIMAL("DECIMAL", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return null;// DataTypes.DECIMAL(precision, scale);
		}
	}),

	TINYINT("短整形（<255）", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.TINYINT();
		}
	}),

	SMALLINT("小整型（<65535）", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.SMALLINT();
		}
	}),

	INT("整型", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.INT();
		}
	}),

	BIGINT("长整型", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.BIGINT();
		}
	}),

	FLOAT("单精度浮点型", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.FLOAT();
		}
	}),

	DOUBLE("双精度浮点型", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.DOUBLE();
		}
	}),

	DATE("日期", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.DATE();
		}
	}),

	TIME("时间", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.TIME();
		}
	}),

	TIMESTAMP("时间戳", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.TIMESTAMP();
		}
	}),

	TIMESTAMP_WITH_LOCAL_TIME_ZONE("TIMESTAMP_WITH_LOCAL_TIME_ZONE", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.TIMESTAMP();
		}
	}),
      //int (number of months)
	INTERVAL_YEAR_TO_MONTH("INTERVAL_YEAR_TO_MONTH", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.INT();
		}
	}),
    //long (number of milliseconds)  
	INTERVAL_DAY_TO_MONTH("INTERVAL_DAY_TO_MONTH", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.BIGINT();
		}
	}),
    //ROW / structured types 
	ROW("ROW", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return DataTypes.ROW();
		}
	}),
    //{@link ArrayData}
	ARRAY("ARRAY", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return null;// DataTypes.ARRAY(elementDataType);
		}
	}),
    // {@link MapData}  
	MAP("MAP", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return null;// DataTypes.MAP(keyDataType, valueDataType);
		}
	}),
     //{@link MapData}  
	MULTISET("MULTISET", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return null;// DataTypes.MAP(keyDataType, valueDataType);
		}
	}),
    //{@link RawValueData}
	RAW("RAW", new ICallBack<DataType>() {
		@Override
		public DataType getObj() {
			return null;// DataTypes.RAW(clazz);
		}
	});

	private final String desc;
	private final ICallBack<DataType> convert;

	private DataTypeEnum(String desc, ICallBack<DataType> convert) {
		this.desc = desc;
		this.convert = convert;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public DataType getDataType() {
		return this.convert.getObj();
	}

	/***
	 * 通过传过来的字符类型得到DataTypeEnum， 注意：TIMESTAMP WITH LOCAL TIME_ZONE 匹配
	 * TIMESTAMP_WITH_LOCAL_TIME_ZONE
	 * 
	 * @param name 字符类型
	 * @return
	 */
	public static DataTypeEnum find(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (DataTypeEnum ele : DataTypeEnum.values()) {
			if (StringUtil.blankToChart(name, "_", true).equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}

}