package net.wicp.tams.common.flink.module;

import java.util.Collections;
import java.util.Set;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.factories.ModuleFactory;
import org.apache.flink.table.module.Module;

/***
 * 如果是在sql
 * 客户端使用，还需要实现ModuleFactory接口，因为加载的时候，flink会使用SPI机制去匹配获取相应的ModuleFactory，然后实例化相应的moudule。
 * 
 * @author Andy
 *
 */
public class TamsModuleFactory implements ModuleFactory {

	@Override
	public String factoryIdentifier() {
		return TamsModuleOptions.IDENTIFIER;
	}

	@Override
	public Set<ConfigOption<?>> requiredOptions() {
		return Collections.emptySet();
	}

	@Override
	public Set<ConfigOption<?>> optionalOptions() {
		return Collections.emptySet();
	}

	@Override
	public Module createModule(Context context) {
		return TamsModule.getInstance();
	}

}