package net.wicp.tams.common.flink.module;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.module.Module;

import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.flink.module.constant.UdfEnum;

public class TamsModule implements Module {
	private static final TamsModule INSTANCE = new TamsModule();
	// private final List<FunctionDefinition> functionDefinitions;
	// private final Set<String> functionNames;

	private final Map<UdfEnum, FunctionDefinition> funmap;

	public static TamsModule getInstance() {
		return INSTANCE;
	}

	private TamsModule() {
		this.funmap = new HashMap<UdfEnum, FunctionDefinition>();
		for (UdfEnum udfEnum : UdfEnum.values()) {
			// 一个一个函数进行添加
			try {
				funmap.put(udfEnum, (FunctionDefinition) udfEnum.getClassz().newInstance());
			} catch (Exception e) {
				throw new ProjectExceptionRuntime(ExceptAll.flink_udf_nodef);
			}
		}
	}

	@Override
	public Set<String> listFunctions() {
		return funmap.keySet().stream().map(UdfEnum::getFullName).collect(Collectors.toSet());
	}

	@Override
	public Optional<FunctionDefinition> getFunctionDefinition(String name) {
		return funmap.keySet().stream().filter(f -> f.getFullName().equalsIgnoreCase(name)).findFirst()
				.map(udf -> funmap.get(udf)); // .stream().filter().map(Function.identity());
	}
}
