package net.wicp.tams.common.flink.module;

import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.functions.FunctionKind;

/****
 * 模块应该定义好此接口,SPI方式 它所定义的枚举函数会自动导入到tams catalog
 * 
 * @author Andy
 *
 */
public interface IUdfEnum {
	/***
	 * 数据对应的类
	 * 
	 * @return
	 */
	public Class<?> getClassz();

	/***
	 * 函数类型
	 * 
	 * @return
	 */
	public FunctionKind getKind();

	public default String getDescription() {
		return "";
	}

	public default String getDetailDescription() {
		return "";
	}

	public default FunctionLanguage getLanguage() {
		return FunctionLanguage.JAVA;
	}

	/**
	 * 函数名
	 * 
	 * @return
	 */
	public String getName();

	/***
	 * 函数的全名，模块_函数名
	 * 
	 * @return
	 */
	public default String getFullName() {
		return String.format("%s_%s", TamsModuleOptions.IDENTIFIER, getName());
	}
}
