package net.wicp.tams.common.flink.module;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;

public abstract class FlinkAssit {
	/**
	 * 根据数据库中存储的数据类型，返回flink中的数据类型 TODO 后面处理
	 * 
	 * @param mysqlType
	 * @return
	 */
	public static DataType mappingType(String mysqlType) {
		switch (mysqlType) {
		case "bigint":
			return DataTypes.BIGINT();
		case "double":
			return DataTypes.DOUBLE();
		case "string":
			return DataTypes.STRING();
		case "timestamp":
			return DataTypes.TIMESTAMP(3);
		default:
			throw new UnsupportedOperationException("current not support " + mysqlType);
		}
	}
}
