/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.module.function;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.flink.common.FlinkAssit;
import net.wicp.tams.common.jdbc.DruidAssit;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.types.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionHint(output=@DataTypeHint(value="ROW<tenant_id STRING,saas_code STRING>"))
public class TenantTableFunction
extends TableFunction<Row> {
    private static final Logger log = LoggerFactory.getLogger(TenantTableFunction.class);
    private static final long serialVersionUID = 1L;
    private final Map<Integer, List<Map<String, String>>> projectTenant = new HashMap<Integer, List<Map<String, String>>>();

    public void eval(Integer project, String tenantId) {
        block6: {
            if (StringUtil.isNull((Object)project)) {
                return;
            }
            if (!this.projectTenant.containsKey(project)) break block6;
            if (StringUtil.isNotNull((Object)tenantId)) {
                for (Map<String, String> data : this.projectTenant.get(project)) {
                    if (!data.containsKey(tenantId)) continue;
                    this.collect(Row.of((Object[])new Object[]{tenantId, data.get(tenantId)}));
                    break;
                }
            } else {
                for (Map<String, String> data : this.projectTenant.get(project)) {
                    for (String key : data.keySet()) {
                        this.collect(Row.of((Object[])new Object[]{key, data.get(key)}));
                    }
                }
            }
        }
    }

    public void eval(Integer project) {
        this.eval(project, null);
    }

    public void open(FunctionContext context) throws Exception {
        super.open(context);
        FlinkAssit.packageConfigForEnv();
        this.init();
        ScheduledExecutorService timerService = Executors.newScheduledThreadPool(1);
        timerService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                TenantTableFunction.this.init();
            }
        }, 1L, 600L, TimeUnit.SECONDS);
    }

    public void close() throws Exception {
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Connection conn = null;
        try {
            conn = DruidAssit.getConnection((String)"tams");
            String defaultDb = DruidAssit.getDefaultDb((String)"tams");
            List querySqlMap = MySqlAssit.querySqlMapPre((Connection)conn, (String)String.format("select saas_tenant_id,project_id,name from %s.dqc_dv_tenant where tenant_id=? and status='yes'", defaultDb), (boolean)false, (Object[])new Object[]{Conf.get((String)"flink.catalog.tenantId")});
            for (Map map : querySqlMap) {
                int projectId = Integer.parseInt((String)map.get("project_id"));
                List<Map<Object, Object>> temp = this.projectTenant.containsKey(projectId) ? this.projectTenant.get(projectId) : new ArrayList<Map>();
                temp.add(CollectionUtil.newMapStr((String[])new String[]{(String)map.get("saas_tenant_id"), (String)map.get("name")}));
                this.projectTenant.put(projectId, temp);
            }
        }
        catch (Throwable e) {
            log.error("save point error:", e);
        }
        finally {
            DruidAssit.close((Connection)conn);
        }
    }
}

