/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.module.function;

import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.flink.common.FlinkAssit;
import net.wicp.tams.common.jdbc.DruidAssit;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.ScalarFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantFunction
extends ScalarFunction {
    private static final Logger log = LoggerFactory.getLogger(TenantFunction.class);
    private static final long serialVersionUID = 1L;
    private final Map<Integer, Set<String>> projectTenant = new HashMap<Integer, Set<String>>();

    public boolean eval(Integer project, String tenantId) {
        return this.projectTenant.containsKey(project) && (this.projectTenant.get(project).contains(tenantId) || this.projectTenant.get(project).contains("*"));
    }

    public void open(FunctionContext context) throws Exception {
        super.open(context);
        FlinkAssit.packageConfigForEnv();
        TenantFunction.init(this.projectTenant);
        ScheduledExecutorService timerService = Executors.newScheduledThreadPool(1);
        timerService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                TenantFunction.init(TenantFunction.this.projectTenant);
            }
        }, 1L, 600L, TimeUnit.SECONDS);
    }

    public void close() throws Exception {
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Map<Integer, Set<String>> projectTenant) {
        Connection conn = null;
        try {
            conn = DruidAssit.getConnection((String)"tams");
            String defaultDb = DruidAssit.getDefaultDb((String)"tams");
            List querySqlMap = MySqlAssit.querySqlMapPre((Connection)conn, (String)String.format("select saas_tenant_id,project_id from %s.dqc_dv_tenant where tenant_id=?", defaultDb), (boolean)false, (Object[])new Object[]{Conf.get((String)"flink.catalog.tenantId")});
            for (Map map : querySqlMap) {
                Set<String> temp = null;
                int projectId = Integer.parseInt((String)map.get("project_id"));
                temp = projectTenant.containsKey(projectId) ? projectTenant.get(projectId) : new HashSet<String>();
                temp.add(StringUtil.trimSpace((String)((String)map.get("saas_tenant_id"))));
                projectTenant.put(projectId, temp);
            }
        }
        catch (Throwable e) {
            log.error("save point error:", e);
        }
        finally {
            DruidAssit.close((Connection)conn);
        }
    }
}

