/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.module.function;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.flink.common.FlinkAssit;
import net.wicp.tams.common.flink.module.function.MiniConvertFunction;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.types.Row;

@FunctionHint(output=@DataTypeHint(value="ROW<mini_code STRING, mini_value STRING>"))
public class MiniTableFunction
extends TableFunction<Row> {
    private static final long serialVersionUID = 1L;
    private final Map<String, HashMap<String, String>> datas = new HashMap<String, HashMap<String, String>>();

    public void eval(String group, String code) {
        if (StringUtil.isNull((Object)group)) {
            return;
        }
        if (this.datas.containsKey(group)) {
            if (StringUtil.isNotNull((Object)code)) {
                if (this.datas.get(group).containsKey(code)) {
                    this.collect(Row.of((Object[])new Object[]{code, this.datas.get(group).get(code)}));
                }
            } else {
                for (String key : this.datas.get(group).keySet()) {
                    this.collect(Row.of((Object[])new Object[]{key, this.datas.get(group).get(key)}));
                }
            }
        }
    }

    public void eval(String group) {
        this.eval(group, null);
    }

    public void open(FunctionContext context) throws Exception {
        super.open(context);
        FlinkAssit.packageConfigForEnv();
        MiniConvertFunction.init(this.datas);
        ScheduledExecutorService timerService = Executors.newScheduledThreadPool(1);
        timerService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                MiniConvertFunction.init(MiniTableFunction.this.datas);
            }
        }, 1L, 600L, TimeUnit.SECONDS);
    }

    public void close() throws Exception {
        super.close();
    }
}

