/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.module.function;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.flink.common.FlinkAssit;
import net.wicp.tams.common.jdbc.DruidAssit;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.ScalarFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniConvertFunction
extends ScalarFunction {
    private static final Logger log = LoggerFactory.getLogger(MiniConvertFunction.class);
    private static final long serialVersionUID = 1L;
    private final Map<String, HashMap<String, String>> datas = new HashMap<String, HashMap<String, String>>();

    public String eval(String group, String code) {
        if (StringUtil.isNull((Object)group)) {
            return "";
        }
        return !this.datas.containsKey(group) ? code : (this.datas.get(group).containsKey(code) ? this.datas.get(group).get(code) : code);
    }

    public void open(FunctionContext context) throws Exception {
        super.open(context);
        FlinkAssit.packageConfigForEnv();
        MiniConvertFunction.init(this.datas);
        ScheduledExecutorService timerService = Executors.newScheduledThreadPool(1);
        timerService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                MiniConvertFunction.init(MiniConvertFunction.this.datas);
            }
        }, 1L, 600L, TimeUnit.SECONDS);
    }

    public void close() throws Exception {
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Map<String, HashMap<String, String>> datas) {
        Connection conn = null;
        try {
            conn = DruidAssit.getConnection((String)"tams");
            String defaultDb = DruidAssit.getDefaultDb((String)"tams");
            List querySqlMap = MySqlAssit.querySqlMapPre((Connection)conn, (String)String.format("select group_code,item_code,name_zh from %s.sys_optitem where  tenant_id=? and status='%s'", defaultDb, YesOrNo.yes.name()), (boolean)false, (Object[])new Object[]{Conf.get((String)"flink.catalog.tenantId")});
            for (Map map : querySqlMap) {
                HashMap<Object, Object> temp = null;
                String group = (String)map.get("group_code");
                temp = datas.containsKey(group) ? datas.get(group) : new HashMap();
                temp.put(StringUtil.trimSpace((String)((String)map.get("item_code"))), StringUtil.trimSpace((String)((String)map.get("name_zh"))));
                datas.put(group, temp);
            }
        }
        catch (Throwable e) {
            log.error("save point error:", e);
        }
        finally {
            DruidAssit.close((Connection)conn);
        }
    }
}

