/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.module.assit;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class Identities {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    static char[] encodeHex(byte[] bytes) {
        char[] chars = new char[32];
        for (int i = 0; i < chars.length; i += 2) {
            byte b = bytes[i / 2];
            chars[i] = HEX_CHARS[b >>> 4 & 0xF];
            chars[i + 1] = HEX_CHARS[b & 0xF];
        }
        return chars;
    }

    public static String hashedIdentifier(String identifier) {
        return new String(Identities.encodeHex(Identities.getMessageDigestInstance().digest(identifier.getBytes(StandardCharsets.UTF_8))));
    }

    public static String generateProfileOneUid(String profileUid, String profileType, String tenantId) {
        String identity = String.format("%s/%s/%s/%s", "LC", profileType, tenantId, profileUid);
        return new String(Identities.encodeHex(Identities.getMessageDigestInstance().digest(identity.getBytes(StandardCharsets.UTF_8))));
    }

    static MessageDigest getMessageDigestInstance() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException var1) {
            var1.printStackTrace();
            return null;
        }
    }

    public static String generatePmsKqOneUid(String patientId, String tenantId) {
        return Identities.generateProfileOneUid(patientId, "PMS_KQ", tenantId);
    }

    public static String generatePmsYmOneUid(String customerId, String tenantId) {
        return Identities.generateProfileOneUid(customerId, "PMS_YM", tenantId);
    }
}

