/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.module.function;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.types.Row;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.flink.common.CatalogAssit;
import net.wicp.tams.common.flink.common.FlinkAssit;
import net.wicp.tams.common.jdbc.DruidAssit;

/***
 * 租户表值,租户id和租户code
 * 
 * @author Andy
 *
 */
@Slf4j
@FunctionHint(output = @DataTypeHint("ROW<tenant_id STRING,saas_code STRING>"))
public class TenantTableFunction extends TableFunction<Row> {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	// projectid,[(saas_code,tenant_name)]
	private final Map<Integer, List<Map<String, String>>> projectTenant = new HashMap<Integer, List<Map<String, String>>>();


	public void eval(Integer project, String tenantId) {
		if (StringUtil.isNull(project)) {// 没有传project就不输出
			return;
		}
		if (projectTenant.containsKey(project)) {
			if (StringUtil.isNotNull(tenantId)) {
				//TODO 会报java.util.ConcurrentModificationException错误
				for (Map<String, String> data : projectTenant.get(project)) {
					if (data.containsKey(tenantId)) {// 含有就输出，没有就是空
						collect(Row.of(tenantId, data.get(tenantId)));
						break;
					}
				}
			} else {// 没有传code就全部输出
				for (Map<String, String> data : projectTenant.get(project)) {
					for (String key : data.keySet()) {
						collect(Row.of(key, data.get(key)));
					}
				}
			}
		}
	}

	public void eval(Integer project) {
		eval(project, null);
	}

	@Override
	public void open(FunctionContext context) throws Exception {
		super.open(context);
		FlinkAssit.packageConfigForEnv();//这步很重要，哪怕在本机测试没有问题，也需要这步，否则在生产环境不能得到正确的数据库配置信息。
//		FlinkAssit.packageConfigForEnvMock();//测试用
		init();// 先执行一次，保证是同步的
		ScheduledExecutorService timerService = Executors.newScheduledThreadPool(1);
		timerService.scheduleAtFixedRate(new Runnable() {
			@Override
			public void run() {
				init();
			}

		}, 1, 600, TimeUnit.SECONDS);
	}

	@Override
	public void close() throws Exception {
		super.close();
//		try {
//			if (scheduleAtFixedRate != null) {
//				scheduleAtFixedRate.cancel(true);
//			}
//		} catch (Exception e) {
//		}
//		try {
//			if (timerService != null) {
//				timerService.shutdown();
//			}
//		} catch (Exception e) {
//		}
	}

	private void init() {
		Connection conn = null;
		try {
			conn = DruidAssit.getConnection(CatalogAssit.IDENTIFIER);
			String defaultDb = DruidAssit.getDefaultDb(CatalogAssit.IDENTIFIER);
			List<Map<String, String>> querySqlMap = MySqlAssit.querySqlMapPre(conn, String.format(
					"select saas_tenant_id,project_id,name from %s.dqc_dv_tenant where tenant_id=? and status='yes'",
					defaultDb), false, Conf.get(CatalogAssit.keyForTenantId));
			for (Map<String, String> map : querySqlMap) {
				List<Map<String, String>> temp;
				int projectId = Integer.parseInt(map.get("project_id"));
				if (projectTenant.containsKey(projectId)) {
					temp = projectTenant.get(projectId);
				} else {
					temp = new ArrayList<Map<String, String>>();
				}
				temp.add(CollectionUtil.newMapStr(map.get("saas_tenant_id"), map.get("name")));
				projectTenant.put(projectId, temp);
			}

		} catch (Throwable e) {
			log.error("save point error:", e);
		} finally {
			DruidAssit.close(conn);
		}
	}
}
