/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.module.function;

import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.ScalarFunction;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.flink.common.CatalogAssit;
import net.wicp.tams.common.flink.common.FlinkAssit;
import net.wicp.tams.common.jdbc.DruidAssit;

/***
 * 判断租户是否是有效租户
 * 
 * @author Andy
 *
 */
@Slf4j
public class TenantFunction extends ScalarFunction {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	// Unable to serialize object 'TenantFunction' of class
	// 'net.wicp.tams.common.flink.module.function.TenantFunction'.
//	private ScheduledExecutorService timerService;
//	private ScheduledFuture<?> scheduleAtFixedRate;

	private final Map<Integer, Set<String>> projectTenant = new HashMap<Integer, Set<String>>();

	public boolean eval(Integer project, String tenantId) {
		return projectTenant.containsKey(project)
				&& (projectTenant.get(project).contains(tenantId) || projectTenant.get(project).contains("*"));
	}

	@Override
	public void open(FunctionContext context) throws Exception {
		super.open(context);
		FlinkAssit.packageConfigForEnv();//这步很重要，哪怕在本机测试没有问题，也需要这步，否则在生产环境不能得到正确的数据库配置信息。
//		FlinkAssit.packageConfigForEnvMock();//测试用
		init(this.projectTenant);// 先执行一次，保证是同步的
		ScheduledExecutorService timerService = Executors.newScheduledThreadPool(1);
		timerService.scheduleAtFixedRate(new Runnable() {
			@Override
			public void run() {
				init(projectTenant);
			}

		}, 1, 600, TimeUnit.SECONDS);
	}

	@Override
	public void close() throws Exception {
		super.close();
//		try {
//			if (scheduleAtFixedRate != null) {
//				scheduleAtFixedRate.cancel(true);
//			}
//		} catch (Exception e) {
//		}
//		try {
//			if (timerService != null) {
//				timerService.shutdown();
//			}
//		} catch (Exception e) {
//		}
	}

	public static void init(Map<Integer, Set<String>> projectTenant) {
		Connection conn = null;
		try {
			conn = DruidAssit.getConnection(CatalogAssit.IDENTIFIER);
			String defaultDb = DruidAssit.getDefaultDb(CatalogAssit.IDENTIFIER);
			List<Map<String, String>> querySqlMap = MySqlAssit.querySqlMapPre(conn, String
					.format("select saas_tenant_id,project_id from %s.dqc_dv_tenant where tenant_id=?", defaultDb),
					false, Conf.get(CatalogAssit.keyForTenantId));
			for (Map<String, String> map : querySqlMap) {
				Set<String> temp = null;
				int projectId = Integer.parseInt(map.get("project_id"));
				if (projectTenant.containsKey(projectId)) {
					temp = projectTenant.get(projectId);
				} else {
					temp = new HashSet<String>();
				}
				temp.add(StringUtil.trimSpace(map.get("saas_tenant_id")));
				projectTenant.put(projectId, temp);
			}

		} catch (Throwable e) {
			log.error("save point error:", e);
		} finally {
			DruidAssit.close(conn);
		}
	}
}
