/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.module.function;

import org.apache.flink.table.functions.ScalarFunction;

/***
 * 截取字符串，从第一个begin字符到第一个end字符
 * 
 * @author Andy
 *
 */
public class SubstrcharFunction extends ScalarFunction {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public String eval(String s, String begin, String end) {
		return eval(s, begin, end, 0);
	}

	/***
	 * 
	 * @param s
	 * @param begin
	 * @param end
	 * @param fromindex 开始搜索的位置，-1为lastIndexOf找begin
	 * @return
	 */
	public String eval(String s, String begin, String end, int fromindex) {
		int indexOf1 = 0;
		int indexOf2 = 0;
		if (fromindex < 0) {
			indexOf1 = s.lastIndexOf(begin);
			indexOf2 = s.indexOf(end, indexOf1);
		} else {
			indexOf1 = s.indexOf(begin, fromindex);
			indexOf2 = s.indexOf(end, indexOf1);
		}
		if (indexOf1 < 0 || indexOf2 < 0 || indexOf1 >= indexOf2) {
			return "";
		}
		return s.substring(indexOf1 + 1, indexOf2);
	}
}
