/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.module.function;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.types.Row;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.flink.common.FlinkAssit;

/***
 * 迷你维表值函数
 * 
 * 
 * @author Andy
 *
 */
@FunctionHint(output = @DataTypeHint("ROW<mini_code STRING, mini_value STRING>"))
public class MiniTableFunction extends TableFunction<Row> {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	// 迷你维所有数据:(groupcode,(itemcode,itemvalue))
	private final Map<String, HashMap<String, String>> datas = new HashMap<String, HashMap<String, String>>();

	public void eval(String group, String code) {
		if (StringUtil.isNull(group)) {// 没有传group就不输出
			return;
		}
		if (datas.containsKey(group)) {
			if (StringUtil.isNotNull(code)) {
				if (datas.get(group).containsKey(code)) {// 含有就输出，没有就是空
					collect(Row.of(code, datas.get(group).get(code)));
				}
			} else {// 没有传code就全部输出
				for (String key : datas.get(group).keySet()) {
					collect(Row.of(key, datas.get(group).get(key)));
				}
			}
		}
	}

	public void eval(String group) {
		eval(group, null);
	}

	@Override
	public void open(FunctionContext context) throws Exception {
		super.open(context);
		FlinkAssit.packageConfigForEnv();//这步很重要，哪怕在本机测试没有问题，也需要这步，否则在生产环境不能得到正确的数据库配置信息。
//		FlinkAssit.packageConfigForEnvMock();//测试用
		MiniConvertFunction.init(this.datas);// 先执行一次，保证是同步的
		ScheduledExecutorService timerService = Executors.newScheduledThreadPool(1);
		timerService.scheduleAtFixedRate(new Runnable() {
			@Override
			public void run() {
				MiniConvertFunction.init(datas);
			}

		}, 1, 600, TimeUnit.SECONDS);
	}

	@Override
	public void close() throws Exception {
		super.close();
	}

}
