/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.module.function;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.ScalarFunction;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.flink.common.CatalogAssit;
import net.wicp.tams.common.flink.common.FlinkAssit;
import net.wicp.tams.common.jdbc.DruidAssit;

/***
 * 迷你维转换
 * 
 * @author Andy
 *
 */
@Slf4j
public class MiniConvertFunction extends ScalarFunction {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	// 迷你维所有数据:(groupcode,(itemcode,itemvalue))
	private final Map<String, HashMap<String, String>> datas = new HashMap<String, HashMap<String, String>>();

	public String eval(String group, String code) {
		if(StringUtil.isNull(group)) {
			return "";//没有解析
		}
		return !datas.containsKey(group) ? code
				: (datas.get(group).containsKey(code) ? datas.get(group).get(code) : code);
	}

	@Override
	public void open(FunctionContext context) throws Exception {
		super.open(context);
		FlinkAssit.packageConfigForEnv();//这步很重要，哪怕在本机测试没有问题，也需要这步，否则在生产环境不能得到正确的数据库配置信息。
//		FlinkAssit.packageConfigForEnvMock();//测试用
		init(this.datas);// 先执行一次，保证是同步的
		ScheduledExecutorService timerService = Executors.newScheduledThreadPool(1);
		timerService.scheduleAtFixedRate(new Runnable() {
			@Override
			public void run() {
				init(datas);
			}

		}, 1, 600, TimeUnit.SECONDS);
	}

	@Override
	public void close() throws Exception {
		super.close();
	}

	public static void init(Map<String, HashMap<String, String>> datas) {
		Connection conn = null;
		try {
			conn = DruidAssit.getConnection(CatalogAssit.IDENTIFIER);
			String defaultDb = DruidAssit.getDefaultDb(CatalogAssit.IDENTIFIER);
//			List<Map<String, String>> querySqlMap = MySqlAssit.querySqlMapPre(conn, String.format(
//					"select group_code,item_code,name_zh from %s.sys_optitem where  tenant_id=? and status='%s'",
//					defaultDb, YesOrNo.yes.name()), false, Conf.get(CatalogAssit.keyForTenantId));
			// 测试用
			List<Map<String, String>> querySqlMap = MySqlAssit.querySqlMapPre(conn,
					String.format(
							"select group_code,item_code,name_zh from %s.sys_optitem where  tenant_id=? and status='%s'",
							defaultDb, YesOrNo.yes.name()),
					false, Conf.get(CatalogAssit.keyForTenantId));
			for (Map<String, String> map : querySqlMap) {
				HashMap<String, String> temp = null;
				String group = map.get("group_code");
				if (datas.containsKey(group)) {
					temp = datas.get(group);
				} else {
					temp = new HashMap<String, String>();
				}
				temp.put(StringUtil.trimSpace(map.get("item_code")), StringUtil.trimSpace(map.get("name_zh")));
				datas.put(group, temp);
			}

		} catch (Throwable e) {
			log.error("save point error:", e);
		} finally {
			DruidAssit.close(conn);
		}
	}
}
