/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.module.constant;

import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.functions.FunctionKind;

import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.flink.common.CatalogAssit;
import net.wicp.tams.common.flink.common.module.IUdfEnum;
import net.wicp.tams.common.flink.module.function.MiniConvertFunction;
import net.wicp.tams.common.flink.module.function.MiniTableFunction;
import net.wicp.tams.common.flink.module.function.OneidDtdtFunction;
import net.wicp.tams.common.flink.module.function.OneidDtbtFunction;
import net.wicp.tams.common.flink.module.function.SubstrcharFunction;
import net.wicp.tams.common.flink.module.function.SubstringFunction;
import net.wicp.tams.common.flink.module.function.TenantFunction;
import net.wicp.tams.common.flink.module.function.TenantTableFunction;

/***
 * 自定义函数枚举。模块不能用dbName框住，方便多db复用！
 *
 * @author Andy
 *
 */
public enum UdfEnum implements IEnumCombobox, IUdfEnum {
	substring("截取2个index字符串", SubstringFunction.class, FunctionKind.SCALAR, CatalogAssit.catalogDefaultDb),
	// cdp生成one的函数
	oneiddtdt("口腔生成oneid", OneidDtdtFunction.class, FunctionKind.SCALAR, CatalogAssit.catalogDefaultDb),
	
	oneiddtbt("医美生成oneid", OneidDtbtFunction.class, FunctionKind.SCALAR, CatalogAssit.catalogDefaultDb),

	substrchar("截取2个chart之间出现的字段串", SubstrcharFunction.class, FunctionKind.SCALAR, CatalogAssit.catalogDefaultDb),
	//
	mini("翻译迷你维code到name", MiniConvertFunction.class, FunctionKind.SCALAR, CatalogAssit.catalogDefaultDb),

	// @DataTypeHint("ROW<mini_code STRING, mini_value STRING>")
	minitb("翻译迷你维code到name", MiniTableFunction.class, FunctionKind.TABLE, CatalogAssit.catalogDefaultDb),

	tenant("判断租户是不是合法", TenantFunction.class, FunctionKind.SCALAR, CatalogAssit.catalogDefaultDb),
	// @DataTypeHint("ROW<saas_code STRING, tenant_name STRING>"
	tenanttb("租户表", TenantTableFunction.class, FunctionKind.TABLE, CatalogAssit.catalogDefaultDb);

	private final String desc;
	private final Class<?> classz;
	private final FunctionKind kind;

	private UdfEnum(String desc, Class<?> classz, FunctionKind kind, String defaultDbName) {
		this.desc = desc;
		this.classz = classz;
		this.kind = kind;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public Class<?> getClassz() {
		return classz;
	}

	public FunctionKind getKind() {
		return kind;
	}

	@Override
	public String getDescription() {
		return this.desc;
	}

	public static UdfEnum find(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (UdfEnum ele : UdfEnum.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}

	@Override
	public String getClassFullName() {
		return this.classz.getName();
	}

}
