/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.module;

import java.util.Collections;
import java.util.Set;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.factories.ModuleFactory;
import org.apache.flink.table.module.Module;

import net.wicp.tams.common.flink.common.module.IUdfEnum;

/***
 * 如果是在sql
 * 客户端使用，还需要实现ModuleFactory接口，因为加载的时候，flink会使用SPI机制去匹配获取相应的ModuleFactory，然后实例化相应的moudule。
 * 
 * @author Andy
 *
 */
public class TamsModuleFactory implements ModuleFactory {
	@Override
	public String factoryIdentifier() {
		return IUdfEnum.IDENTIFIER;
	}

	@Override
	public Set<ConfigOption<?>> requiredOptions() {
		return Collections.emptySet();
	}

	@Override
	public Set<ConfigOption<?>> optionalOptions() {
		return Collections.emptySet();
	}

	@Override
	public Module createModule(Context context) {
		return TamsModule.getInstance();
	}

}
