/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.k8s.constant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.wicp.tams.common.apiext.jdbc.MySqlColBean;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.flink.k8s.constant.FlinkTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.expressions.SqlCallExpression;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

public abstract class CatalogAssit {
    private CatalogAssit() {
    }

    public static DataType findColType(MySqlColBean col) {
        FlinkTypeEnum flinkTypeEnum = FlinkTypeEnum.valueOf(col.getFlinkTypeEnum());
        if (flinkTypeEnum == null) {
            throw new CatalogException("\u6b64\u7c7b\u578b[" + col.getColumnNameStandard(FieldFormart.dbstandard) + "]\u8fd8\u4e0d\u652f\u6301\uff0c\u9700\u8981\u8fde\u63a5\u76f8\u5173\u4eba\u5458\u3002");
        }
        DataType dataType = null;
        if (flinkTypeEnum == FlinkTypeEnum.DECIMAL) {
            int dataPrecision = (int)col.getMaxlength();
            int scale = col.getNumericScale();
            dataType = flinkTypeEnum.getConvert().getObj(dataPrecision, scale);
        } else {
            dataType = (DataType)flinkTypeEnum.getConvert().getObj();
        }
        dataType = col.isPri() || col.isNotNull() ? (DataType)dataType.notNull() : (DataType)dataType.nullable();
        return dataType;
    }

    public static List<MySqlColBean> packageColBeans(CatalogBaseTable table, String tableName) {
        Optional primaryKey = table.getUnresolvedSchema().getPrimaryKey();
        List primaryKeys = primaryKey.isPresent() ? ((Schema.UnresolvedPrimaryKey)primaryKey.get()).getColumnNames() : new ArrayList();
        HashMap<String, String> watermark = new HashMap<String, String>();
        List watermarkSpecs = table.getUnresolvedSchema().getWatermarkSpecs();
        if (CollectionUtils.isNotEmpty((Collection)watermarkSpecs)) {
            for (Schema.UnresolvedWatermarkSpec unresolvedWatermarkSpec : watermarkSpecs) {
                String expression = "";
                if (unresolvedWatermarkSpec.getWatermarkExpression() instanceof SqlCallExpression) {
                    SqlCallExpression sqlCallExpression = (SqlCallExpression)unresolvedWatermarkSpec.getWatermarkExpression();
                    expression = sqlCallExpression.getSqlExpression();
                } else {
                    expression = unresolvedWatermarkSpec.getWatermarkExpression().asSummaryString().replace("[", "").replace("]", "");
                }
                watermark.put(unresolvedWatermarkSpec.getColumnName(), expression);
            }
        }
        ArrayList<MySqlColBean> mysqlColList = new ArrayList<MySqlColBean>();
        List columns = table.getUnresolvedSchema().getColumns();
        for (Schema.UnresolvedColumn column : columns) {
            String type = "";
            String sqlexpression = "";
            MySqlColBean tempbean = new MySqlColBean(column.getName(), type);
            if (column instanceof Schema.UnresolvedPhysicalColumn) {
                Schema.UnresolvedPhysicalColumn temp = (Schema.UnresolvedPhysicalColumn)column;
                try {
                    LogicalTypeRoot typeRoot = ((AtomicDataType)temp.getDataType()).getLogicalType().getTypeRoot();
                    FlinkTypeEnum flinkTypeEnum = FlinkTypeEnum.valueOf(typeRoot.name());
                    type = flinkTypeEnum.name();
                }
                catch (Exception e) {
                    throw new CatalogException("\u521b\u5efa\u8868[" + tableName + "]\u65f6\u7c7b\u578b\u68c0\u67e5\u5f02\u5e38\uff0c\u539f\u56e0\uff1a\u8fd8\u4e0d\u652f\u6301\u6b64\u7c7b\u578b[" + temp.getName() + "]" + e.getMessage(), (Throwable)e);
                }
            } else if (column instanceof Schema.UnresolvedComputedColumn) {
                Schema.UnresolvedComputedColumn temp = (Schema.UnresolvedComputedColumn)column;
                if (temp.getExpression() instanceof SqlCallExpression) {
                    SqlCallExpression sqlCallExpression = (SqlCallExpression)temp.getExpression();
                    sqlexpression = sqlCallExpression.getSqlExpression();
                } else {
                    sqlexpression = temp.getExpression().asSummaryString().replace("[", "").replace("]", "");
                }
            } else if (column instanceof Schema.UnresolvedMetadataColumn) {
                Schema.UnresolvedMetadataColumn temp = (Schema.UnresolvedMetadataColumn)column;
                tempbean.setMetadata(true);
                tempbean.setMetadataName(temp.getMetadataKey());
                tempbean.setVirtual(temp.isVirtual());
            }
            boolean isKey = primaryKeys.contains(column.getName());
            tempbean.setPri(isKey);
            tempbean.setDataType("");
            tempbean.setFlinkTypeEnum(type);
            tempbean.setSqlExpression(sqlexpression);
            tempbean.setWatermarkExpression(watermark.containsKey(column.getName()) ? (String)watermark.get(column.getName()) : "");
            mysqlColList.add(tempbean);
        }
        return mysqlColList;
    }
}

