/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.k8s;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlColBean;
import net.wicp.tams.common.apiext.jdbc.MySqlTbBean;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.Middleware;
import net.wicp.tams.common.constant.MiddlewareOption;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.flink.k8s.CrdVesion;
import net.wicp.tams.common.flink.k8s.constant.CatalogAssit;
import net.wicp.tams.common.kubernetes.apiserver.crd.ICrdDef;
import net.wicp.tams.common.kubernetes.driver.KubernetesConnection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.exceptions.TablePartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCatalog
extends AbstractCatalog {
    private static final Logger log = LoggerFactory.getLogger(KubernetesCatalog.class);
    private static final String PRE_TB = "t_";
    private static final String PRE_VIEW = "v_";
    private static final String LABLE_CATALOG = "catalog";
    private static final String LABLE_DB = "db";
    private static final String LABLE_TB = "tb";
    private final String namespace;
    private final Set<String> dbs = new TreeSet<String>();
    private KubernetesConnection connection;

    public KubernetesCatalog(String catalogName, String defaultDatabase, String namespace) {
        super(catalogName, defaultDatabase);
        this.namespace = namespace;
    }

    public void open() throws CatalogException {
        Conf.overProp((String[])new String[]{"common.kubernetes.crd.enum.crd1", "net.wicp.tams.common.flink.k8s.CrdVesion"});
        try {
            this.connection = new KubernetesConnection("jdbc:k8s://localhost?context=yaboshi&conf=~/.kube/config");
            this.connection.setSchema(this.namespace);
        }
        catch (Exception e) {
            log.error("\u83b7\u5f97\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.jdbc_conn_fail, (Throwable)e);
        }
        if (!this.connection.getClientTams().existCrd((ICrdDef)CrdVesion.fcdb)) {
            this.connection.getClientTams().installCrd("/crd/fcdb.yaml", KubernetesCatalog.class);
        }
        if (!this.connection.getClientTams().existCrd((ICrdDef)CrdVesion.fctb)) {
            this.connection.getClientTams().installCrd("/crd/fctb.yaml", KubernetesCatalog.class);
        }
        if (!this.connection.getClientTams().existCrd((ICrdDef)CrdVesion.fcview)) {
            this.connection.getClientTams().installCrd("/crd/fcview.yaml", KubernetesCatalog.class);
        }
        this.cacheDb();
        try {
            this.createDatabase(this.getDefaultDatabase(), null, true);
        }
        catch (CatalogException | DatabaseAlreadyExistException e1) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.jdbc_exec_fail, "\u521d\u59cb\u5316default\u5e93\u5931\u8d25", e1);
        }
    }

    public void cacheDb() {
        List rslist = this.connection.getClientTams().selCusObject((ICrdDef)CrdVesion.fcdb, this.namespace, null);
        if (CollectionUtils.isEmpty((Collection)rslist)) {
            this.connection.getClientTams().createCusObject((ICrdDef)CrdVesion.fcdb, this.namespace, IOUtil.fileToInputStream((String)"/crd/fcdb-default.yaml", KubernetesCatalog.class));
            rslist = this.connection.getClientTams().selCusObject((ICrdDef)CrdVesion.fcdb, this.namespace, null);
        }
        HashMap catalogtodb = new HashMap();
        for (GenericKubernetesResource rs : rslist) {
            Map labels = rs.getMetadata().getLabels();
            String catalog = (String)labels.get(LABLE_CATALOG);
            String db = (String)labels.get(LABLE_DB);
            if (catalogtodb.containsKey(catalog)) {
                ((List)catalogtodb.get(catalog)).add(db);
                continue;
            }
            ArrayList<String> dbs = new ArrayList<String>();
            dbs.add(db);
            catalogtodb.put(catalog, dbs);
        }
        if (!catalogtodb.containsKey(this.getName())) {
            String catalogs = CollectionUtil.listJoin(catalogtodb.keySet(), (String)",");
            throw new CatalogException("\u4e0d\u5b58\u5728\u8fd9\u4e2acatalog,\u4f60\u53ef\u4ee5\u9009\u62e9\u4f7f\u7528\u5982\u4e0bcatalog\uff1a" + catalogs);
        }
        this.dbs.addAll((Collection)catalogtodb.get(this.getName()));
    }

    public void close() throws CatalogException {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            log.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
        }
    }

    public List<String> listDatabases() throws CatalogException {
        return new ArrayList<String>(this.dbs);
    }

    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException, CatalogException {
        if (!this.dbs.contains(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        return new CatalogDatabaseImpl(new HashMap(), "k8s\u5e93");
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        List selCusObjectByLabel = this.connection.getClientTams().selCusObjectByLabel((ICrdDef)CrdVesion.fctb, this.namespace, new String[]{LABLE_CATALOG, this.getName(), LABLE_DB, databaseName});
        TreeSet retset = new TreeSet();
        for (GenericKubernetesResource rs : selCusObjectByLabel) {
            retset.add(rs.getMetadata().getLabels().get(LABLE_TB));
        }
        return new ArrayList<String>(retset);
    }

    public List<String> listViews(String databaseName) throws DatabaseNotExistException, CatalogException {
        List selCusObjectByLabel = this.connection.getClientTams().selCusObjectByLabel((ICrdDef)CrdVesion.fcview, this.namespace, new String[]{LABLE_CATALOG, this.getName(), LABLE_DB, databaseName});
        TreeSet retset = new TreeSet();
        for (GenericKubernetesResource rs : selCusObjectByLabel) {
            retset.add(rs.getMetadata().getLabels().get(LABLE_TB));
        }
        return new ArrayList<String>(retset);
    }

    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        String objectName = tablePath.getObjectName();
        try {
            if (objectName.startsWith(PRE_TB)) {
                List rslist = this.connection.getClientTams().selCusObjectByLabel((ICrdDef)CrdVesion.fctb, this.namespace, new String[]{LABLE_CATALOG, this.getName(), LABLE_DB, tablePath.getDatabaseName(), LABLE_TB, tablePath.getObjectName()});
                if (rslist.isEmpty()) {
                    throw new TableNotExistException(this.getName(), tablePath);
                }
                Map spec = (Map)((GenericKubernetesResource)rslist.get(0)).getAdditionalProperties().get("spec");
                List def = (List)spec.get("col_def");
                ObjectMapper objmap = new ObjectMapper();
                List collist = def.stream().map(e -> (MySqlColBean)objmap.convertValue(e, MySqlColBean.class)).collect(Collectors.toList());
                Schema.Builder schemaBuilder = Schema.newBuilder();
                String comment = String.valueOf(spec.get("remark"));
                ArrayList<String> priList = new ArrayList<String>();
                for (MySqlColBean mySqlColBean : collist) {
                    String colname = mySqlColBean.getColumnNameStandard(FieldFormart.dbstandard);
                    if (mySqlColBean.isPri()) {
                        priList.add(colname);
                    }
                    if (StringUtil.isNotNull((Object)mySqlColBean.getWatermarkExpression())) {
                        schemaBuilder.watermark(colname, mySqlColBean.getWatermarkExpression());
                    }
                    if (StringUtil.isNotNull((Object)mySqlColBean.getSqlExpression())) {
                        schemaBuilder.columnByExpression(colname, mySqlColBean.getSqlExpression());
                    } else if (mySqlColBean.isNotNull() && mySqlColBean.isMetadata()) {
                        String metadataName = StringUtil.isNull((Object)mySqlColBean.getMetadataName()) ? null : mySqlColBean.getMetadataName();
                        DataType dataType = CatalogAssit.findColType(mySqlColBean);
                        schemaBuilder.columnByMetadata(colname, (AbstractDataType)dataType, metadataName, mySqlColBean.isVirtual());
                    } else {
                        DataType dataType = CatalogAssit.findColType(mySqlColBean);
                        schemaBuilder.column(colname, (AbstractDataType)dataType);
                    }
                    if (!StringUtil.isNotNull((Object)mySqlColBean.getColumnComment())) continue;
                    schemaBuilder.withComment(mySqlColBean.getColumnComment());
                }
                CatalogTable.Builder tbBuilder = CatalogTable.newBuilder();
                tbBuilder.partitionKeys(priList);
                if (spec.containsKey("withOptions")) {
                    tbBuilder.options((Map)spec.get("withOptions"));
                }
                tbBuilder.comment(comment);
                tbBuilder.schema(schemaBuilder.build());
                return tbBuilder.build();
            }
            if (!objectName.startsWith(PRE_VIEW)) {
                throw new TableNotExistException(super.getName(), tablePath);
            }
        }
        catch (TableNotExistException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new CatalogException("\u67e5\u8be2table\u5931\u8d25", (Throwable)e3);
        }
        return null;
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        try {
            CatalogBaseTable baseTable = this.getTable(tablePath);
            return baseTable != null;
        }
        catch (TableNotExistException e) {
            return false;
        }
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        String objectName;
        CatalogBaseTable baseTable;
        block6: {
            try {
                this.validDb(tablePath);
            }
            catch (DatabaseNotExistException e1) {
                if (ignoreIfNotExists) break block6;
                throw new TableNotExistException(this.getName(), tablePath);
            }
        }
        try {
            baseTable = this.getTable(tablePath);
        }
        catch (TableNotExistException e) {
            baseTable = null;
        }
        if (!ignoreIfNotExists && baseTable == null) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        if (baseTable != null && (objectName = tablePath.getObjectName()).startsWith(PRE_TB) && baseTable.getTableKind() == CatalogBaseTable.TableKind.TABLE) {
            this.connection.getClientTams().deleteCusObjectByLabel((ICrdDef)CrdVesion.fctb, this.namespace, new String[]{LABLE_CATALOG, this.getName(), LABLE_DB, tablePath.getDatabaseName(), LABLE_TB, tablePath.getObjectName()});
        }
    }

    public void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws TableNotExistException, TableAlreadyExistException, CatalogException {
        String objectName;
        CatalogBaseTable baseTable;
        block6: {
            try {
                this.validDb(tablePath);
            }
            catch (DatabaseNotExistException e1) {
                if (ignoreIfNotExists) break block6;
                throw new TableNotExistException(this.getName(), tablePath);
            }
        }
        try {
            baseTable = this.getTable(tablePath);
        }
        catch (TableNotExistException e) {
            baseTable = null;
        }
        if (!ignoreIfNotExists && baseTable == null) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        if (baseTable != null && (objectName = tablePath.getObjectName()).startsWith(PRE_TB) && baseTable.getTableKind() == CatalogBaseTable.TableKind.TABLE) {
            List crdList = this.connection.getClientTams().selCusObjectByLabel((ICrdDef)CrdVesion.fctb, this.namespace, new String[]{LABLE_CATALOG, this.getName(), LABLE_DB, tablePath.getDatabaseName(), LABLE_TB, tablePath.getObjectName()});
            this.connection.getClientTams().deleteCusObjectByLabel((ICrdDef)CrdVesion.fctb, this.namespace, new String[]{LABLE_CATALOG, this.getName(), LABLE_DB, tablePath.getDatabaseName(), LABLE_TB, tablePath.getObjectName()});
            Map labels = CollectionUtil.newMapStr((String[])new String[]{LABLE_CATALOG, this.getName(), LABLE_DB, tablePath.getDatabaseName(), LABLE_TB, newTableName});
            Map spec = (Map)((GenericKubernetesResource)crdList.get(0)).getAdditionalProperties().get("spec");
            this.connection.getClientTams().createCusObject((ICrdDef)CrdVesion.fctb, this.namespace, this.getCrdName(tablePath.getDatabaseName(), newTableName), null, labels, spec);
        }
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        CatalogBaseTable baseTable;
        this.validDb(tablePath);
        try {
            baseTable = this.getTable(tablePath);
        }
        catch (TableNotExistException e) {
            baseTable = null;
        }
        if (!ignoreIfExists && baseTable != null) {
            throw new TableAlreadyExistException(this.getName(), tablePath);
        }
        if (baseTable == null) {
            String objectName = tablePath.getObjectName();
            if (objectName.startsWith(PRE_TB) && table.getTableKind() == CatalogBaseTable.TableKind.TABLE) {
                try {
                    List<MySqlColBean> mysqlColList = CatalogAssit.packageColBeans(table, objectName);
                    String partitionkeys = "";
                    CatalogTable tableTrue = (CatalogTable)table;
                    if (CollectionUtils.isNotEmpty((Collection)tableTrue.getPartitionKeys())) {
                        partitionkeys = CollectionUtil.listJoin((Collection)tableTrue.getPartitionKeys(), (String)",");
                    }
                    HashMap allOptmap = new HashMap();
                    Map options = table.getOptions();
                    if (MapUtils.isNotEmpty((Map)options)) {
                        for (String optionstr : options.keySet()) {
                            MiddlewareOption findByNameUse = MiddlewareOption.findByNameUse((String)optionstr);
                            if (findByNameUse != null) {
                                allOptmap.put(findByNameUse, options.get(optionstr));
                                continue;
                            }
                            throw new CatalogException("\u521b\u5efa\u8868[" + objectName + "]\u65f6\u68c0\u67e5\u5f02\u5e38\uff0c\u539f\u56e0:catalog\u8fd8\u4e0d\u652f\u6301\u6b64option[" + optionstr + "].");
                        }
                    }
                    Pair proOptStr = Middleware.proOptStr(allOptmap, (MiddlewareOption[])allOptmap.keySet().toArray(new MiddlewareOption[allOptmap.size()]));
                    MySqlTbBean catalogTbInfo = MySqlTbBean.builder().db(tablePath.getDatabaseName()).tb(objectName).tbComment("\u901a\u8fc7sql\u521b\u5efa").middleware(Middleware.no).partitionkeys(partitionkeys).opt((String)proOptStr.getRight()).catalogName(super.getName()).withOptions((String)proOptStr.getLeft()).build();
                    this.createTable(mysqlColList, catalogTbInfo);
                }
                catch (ProjectException e) {
                    throw new CatalogException("\u521b\u5efa\u8868[" + objectName + "]\u65f6SQL\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + e.getMessage(), (Throwable)e);
                }
            } else if (!objectName.startsWith(PRE_VIEW) || table.getTableKind() != CatalogBaseTable.TableKind.VIEW) {
                throw new CatalogException(String.format("\u8868\u4ee5t_\u5f00\u5934\uff0c\u89c6\u56fe\u4ee5v_\u5f00\u5934\uff0c\u4e0d\u5b58\u5728\u6b64\u7c7b\u578b\u7684\u5bf9\u8c61[%s]", tablePath));
            }
        }
    }

    private void createTable(List<MySqlColBean> mysqlColList, MySqlTbBean catalogTbInfo) throws ProjectException {
        try {
            HashMap<String, String> lables = new HashMap<String, String>();
            lables.put(LABLE_CATALOG, this.getName());
            lables.put(LABLE_DB, catalogTbInfo.getDb());
            lables.put(LABLE_TB, catalogTbInfo.getTb());
            HashMap<String, String> spec = new HashMap<String, String>();
            spec.put("remark", catalogTbInfo.getTbComment());
            ObjectMapper objmap = new ObjectMapper();
            ArrayNode fieldNode = (ArrayNode)objmap.valueToTree(mysqlColList);
            spec.put("col_def", (String)fieldNode);
            String crName = this.getCrdName(catalogTbInfo.getDb(), catalogTbInfo.getTb());
            this.connection.getClientTams().createCusObject((ICrdDef)CrdVesion.fctb, this.namespace, crName, null, lables, spec);
        }
        catch (Exception e) {
            throw new ProjectException((IExcept)ExceptAll.flink_catalog_table, "\u521b\u5efa\u8868[" + catalogTbInfo.getDb() + "." + catalogTbInfo.getTb() + "]\u65f6SQL\u5f02\u5e38", (Throwable)e);
        }
    }

    private String getCrdName(String db, String tb) {
        String crName = String.format("%s.%s.%s", StringUtil.formatRfc1123((String)this.getName()), StringUtil.formatRfc1123((String)db), StringUtil.formatRfc1123((String)tb));
        crName = crName.length() > 63 ? crName.substring(0, 63) : crName;
        return crName;
    }

    private void validDb(ObjectPath tablePath) throws DatabaseNotExistException {
        CatalogDatabase database;
        try {
            database = this.getDatabase(tablePath.getDatabaseName());
        }
        catch (DatabaseNotExistException e) {
            database = null;
        }
        if (database == null) {
            throw new DatabaseNotExistException(this.getName(), tablePath.getDatabaseName());
        }
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        this.dropTable(tablePath, true);
        try {
            this.createTable(tablePath, newTable, false);
        }
        catch (DatabaseNotExistException | TableAlreadyExistException e) {
            throw new CatalogException(e);
        }
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        return null;
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        return null;
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> filters) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        return null;
    }

    public CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        return null;
    }

    public boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return false;
    }

    public void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException {
    }

    public void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
    }

    public void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
    }

    public List<String> listFunctions(String dbName) throws DatabaseNotExistException, CatalogException {
        return null;
    }

    public CatalogFunction getFunction(ObjectPath functionPath) throws FunctionNotExistException, CatalogException {
        return null;
    }

    public boolean functionExists(ObjectPath functionPath) throws CatalogException {
        try {
            CatalogFunction function = this.getFunction(functionPath);
            return function != null;
        }
        catch (FunctionNotExistException e) {
            return false;
        }
    }

    public void createFunction(ObjectPath functionPath, CatalogFunction function, boolean ignoreIfExists) throws FunctionAlreadyExistException, DatabaseNotExistException, CatalogException {
    }

    public void alterFunction(ObjectPath functionPath, CatalogFunction newFunction, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        this.dropFunction(functionPath, ignoreIfNotExists);
        try {
            this.createFunction(functionPath, newFunction, ignoreIfNotExists);
        }
        catch (FunctionAlreadyExistException e) {
            throw new CatalogException((Throwable)e);
        }
        catch (DatabaseNotExistException e) {
            throw new CatalogException((Throwable)e);
        }
    }

    public void dropFunction(ObjectPath functionPath, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return null;
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return null;
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        return null;
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        return null;
    }

    public void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
    }

    public void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException, TablePartitionedException {
    }

    public void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
    }

    public void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        return this.dbs.contains(databaseName);
    }

    public void createDatabase(String name, CatalogDatabase database, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        if (this.dbs.contains(name)) {
            if (ignoreIfExists) {
                return;
            }
            throw new DatabaseAlreadyExistException(this.getName(), name);
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put(LABLE_CATALOG, this.getName());
        labels.put(LABLE_DB, name);
        HashMap<String, String> spec = new HashMap<String, String>();
        String remark = database == null || StringUtil.isNull((Object)database.getComment()) ? DateFormatCase.YYYY_MM_DD.getInstanc().format(System.currentTimeMillis()) : database.getComment();
        spec.put("remark", remark);
        this.connection.getClientTams().createCusObject((ICrdDef)CrdVesion.fcdb, this.namespace, String.format("%s.%s", this.getName(), name), null, labels, spec);
        this.dbs.add(name);
    }

    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException {
        if (!this.dbs.contains(name)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new DatabaseNotExistException(this.getName(), name);
        }
        List labels = this.connection.getClientTams().selCusObjectByLabel((ICrdDef)CrdVesion.fcdb, this.namespace, new String[]{LABLE_CATALOG, this.getName(), LABLE_DB, name});
        this.connection.getClientTams().deleteCusObject((ICrdDef)CrdVesion.fcdb, this.namespace, ((GenericKubernetesResource)labels.get(0)).getMetadata().getName());
        this.dbs.remove(name);
    }

    public void alterDatabase(String name, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        throw new CatalogException("\u4e0d\u652f\u6301\u4fee\u6539db");
    }
}

