package net.wicp.tams.common.flink.k8s.constant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.table.api.Schema.UnresolvedColumn;
import org.apache.flink.table.api.Schema.UnresolvedComputedColumn;
import org.apache.flink.table.api.Schema.UnresolvedMetadataColumn;
import org.apache.flink.table.api.Schema.UnresolvedPhysicalColumn;
import org.apache.flink.table.api.Schema.UnresolvedPrimaryKey;
import org.apache.flink.table.api.Schema.UnresolvedWatermarkSpec;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.expressions.SqlCallExpression;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

import net.wicp.tams.common.apiext.jdbc.MySqlColBean;
import net.wicp.tams.common.constant.FieldFormart;

public abstract class CatalogAssit {
	private CatalogAssit() {

	}

	// 数据库数据转为flink类型
	public static DataType findColType(MySqlColBean col) {
		FlinkTypeEnum flinkTypeEnum = FlinkTypeEnum.valueOf(col.getFlinkTypeEnum());//FlinkTypeEnum.findByFlinkRowType(col.getFlinkTypeEnum());
		if (flinkTypeEnum == null) {
			throw new CatalogException("此类型[" + col.getColumnNameStandard(FieldFormart.dbstandard) + "]还不支持，需要连接相关人员。");
		}
		DataType dataType = null;
		if (flinkTypeEnum == FlinkTypeEnum.DECIMAL) {
			int dataPrecision = (int) col.getMaxlength();
			int scale = col.getNumericScale();
			dataType = flinkTypeEnum.getConvert().getObj(dataPrecision, scale);
		} else {
			dataType = flinkTypeEnum.getConvert().getObj();
		}
		if (col.isPri() || col.isNotNull()) {// 主键或定义为不为空。 Invalid primary key
			// 'PK_one_uid_tenant_uid_shop_id_order_id_customer_id'.
			// Column 'one_uid' is nullable.
			dataType = dataType.notNull();
		} else {
			dataType = dataType.nullable();
		}
		return dataType;
	}

	public static List<MySqlColBean> packageColBeans(CatalogBaseTable table, String tableName) {
		// 主键
		Optional<UnresolvedPrimaryKey> primaryKey = table.getUnresolvedSchema().getPrimaryKey();
		List<String> primaryKeys = primaryKey.isPresent() ? primaryKey.get().getColumnNames() : new ArrayList<String>();
		// 缓存watermark
		Map<String, String> watermark = new HashMap<String, String>();
		// 多个watermark?暂时只支持一个吧。
		List<UnresolvedWatermarkSpec> watermarkSpecs = table.getUnresolvedSchema().getWatermarkSpecs();
		if (CollectionUtils.isNotEmpty(watermarkSpecs)) {
			for (UnresolvedWatermarkSpec unresolvedWatermarkSpec : watermarkSpecs) {
				String expression = "";
				if (unresolvedWatermarkSpec.getWatermarkExpression() instanceof SqlCallExpression) {
					SqlCallExpression sqlCallExpression = (SqlCallExpression) unresolvedWatermarkSpec
							.getWatermarkExpression();
					expression = sqlCallExpression.getSqlExpression();
				} else {
					expression = unresolvedWatermarkSpec.getWatermarkExpression().asSummaryString().replace("[", "")
							.replace("]", "");
				}
				watermark.put(unresolvedWatermarkSpec.getColumnName(), expression);
			}
		}

		List<MySqlColBean> mysqlColList = new ArrayList<MySqlColBean>();

		List<UnresolvedColumn> columns = table.getUnresolvedSchema().getColumns();
		for (UnresolvedColumn column : columns) {
			String type = "";
			String sqlexpression = "";
//						String watermarkRowTimeAttribute = "";
//						String watermarkExpression = "";
			// TODO meta支持
			MySqlColBean tempbean = new MySqlColBean(column.getName(), type);
			if (column instanceof UnresolvedPhysicalColumn) {// TODO 细分不同的表
				UnresolvedPhysicalColumn temp = (UnresolvedPhysicalColumn) column;
				try {
					// TODO 逻辑表信息丢失了， 如何处理逻辑表？
					LogicalTypeRoot typeRoot = ((AtomicDataType) temp.getDataType()).getLogicalType().getTypeRoot();
					FlinkTypeEnum flinkTypeEnum = FlinkTypeEnum.valueOf(typeRoot.name());
					type = flinkTypeEnum.name();
				} catch (Exception e) {
					throw new CatalogException(
							"创建表[" + tableName + "]时类型检查异常，原因：还不支持此类型[" + temp.getName() + "]" + e.getMessage(), e);
				}
			} else if (column instanceof UnresolvedComputedColumn) {// 计算字段
				UnresolvedComputedColumn temp = (UnresolvedComputedColumn) column;
				if (temp.getExpression() instanceof SqlCallExpression) {
					SqlCallExpression sqlCallExpression = (SqlCallExpression) temp.getExpression();
					sqlexpression = sqlCallExpression.getSqlExpression();
				} else {
					sqlexpression = temp.getExpression().asSummaryString().replace("[", "").replace("]", "");
				}
			} else if (column instanceof UnresolvedMetadataColumn) {// Metadata列支持
				UnresolvedMetadataColumn temp = (UnresolvedMetadataColumn) column;
				tempbean.setMetadata(true);
				tempbean.setMetadataName(temp.getMetadataKey());
				tempbean.setVirtual(temp.isVirtual());
			}
//						tempbean.setDb(tablePath.getDatabaseName());
//						tempbean.setTb(objectName);
			boolean isKey = primaryKeys.contains(column.getName());
			tempbean.setPri(isKey);
			tempbean.setDataType("");// 这里不是mysql类型
			tempbean.setFlinkTypeEnum(type);// flink的类型，
			tempbean.setSqlExpression(sqlexpression);
			tempbean.setWatermarkExpression(
					watermark.containsKey(column.getName()) ? watermark.get(column.getName()) : "");// 设置watermark
			mysqlColList.add(tempbean);
		}
		return mysqlColList;
	}


}
