/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.k8s;

import java.util.HashSet;
import java.util.Set;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.FactoryUtil;

public class KubernetesCatalogFactory implements CatalogFactory {

	@Override
	public String factoryIdentifier() {
		return KubernetesCatalogFactoryOptions.IDENTIFIER;
	}

	@Override
	public Set<ConfigOption<?>> requiredOptions() {
		final Set<ConfigOption<?>> options = new HashSet<>();
		options.add(KubernetesCatalogFactoryOptions.namespace);
		options.add(KubernetesCatalogFactoryOptions.defaultdb);		
		return options;
	}

	@Override
	public Set<ConfigOption<?>> optionalOptions() {
		final Set<ConfigOption<?>> options = new HashSet<>();
		return options;
	}

	@Override
	public Catalog createCatalog(Context context) {
		final FactoryUtil.CatalogFactoryHelper helper = FactoryUtil.createCatalogFactoryHelper(this, context);
		helper.validate();
		final ReadableConfig options = helper.getOptions();
		return new KubernetesCatalog(context.getName(), options.get(KubernetesCatalogFactoryOptions.defaultdb),
				options.get(KubernetesCatalogFactoryOptions.namespace));
	}

}
