package net.wicp.tams.common.flink.k8s;

import org.apache.commons.lang3.StringUtils;

import net.wicp.tams.common.kubernetes.apiserver.crd.ICrdDef;

/***
 * k8s的资源类型
 * 
 * @author andy.zhou
 * 
 */
public enum CrdVesion implements ICrdDef {
	fcdb("数据库", "fcdb", "net.wicp.tams", "fcdbs", "Namespaced", "fcdb", new String[] { "fcdb" }, new String[] { "v1" }),

	fctb("数据库", "fctb", "net.wicp.tams", "fctbs", "Namespaced", "fctb", new String[] { "fctb" }, new String[] { "v1" }),

	fcview("数据库", "fcview", "net.wicp.tams", "fcviews", "Namespaced", "fcview", new String[] { "fcview" },
			new String[] { "v1" });

	private final String desc;
	private final String desc_en;
	private final String group;
	private final String plural;
	private final String scope;
	private final String kind;
	private final String[] shortNames;
	private final String[] versions;

	public String[] getVersions() {
		return versions;
	}

	private CrdVesion(String desc, String desc_en, String group, String plural, String scope, String kind,
			String[] shortNames, String[] versions) {
		this.desc = desc;
		this.desc_en = desc_en;
		this.versions = versions;
		this.group = group;
		this.plural = plural;
		this.scope = scope;
		this.kind = kind;
		this.shortNames = shortNames;
	}

	public String getCrName() {
		return this.desc.toLowerCase();
	}

	public String getApiVersion() {
		return String.format("%s/%s", this.getGroup(), this.versions[0]);
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	public String getGroup() {
		return group;
	}

	public String getPlural() {
		return plural;
	}

	public String getScope() {
		return scope;
	}

	public String getKind() {
		return kind;
	}

	public String[] getShortNames() {
		return shortNames;
	}

	public static CrdVesion findByKind(String kind) {
		if (StringUtils.isEmpty(kind)) {
			return null;
		}
		for (CrdVesion ele : CrdVesion.values()) {
			if (kind.equalsIgnoreCase(ele.getKind())) {
				return ele;
			}
		}
		return null;
	}

	public String getDesc_en() {
		return desc_en;
	}

}
