/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.connector.redis.container;

import java.util.Objects;
import net.wicp.tams.common.flink.connector.redis.config.FlinkJedisConfigBase;
import net.wicp.tams.common.flink.connector.redis.config.FlinkJedisPoolConfig;
import net.wicp.tams.common.flink.connector.redis.container.RedisCommandsContainer;
import net.wicp.tams.common.flink.connector.redis.container.RedisContainer;
import net.wicp.tams.common.flink.connector.redis.options.RedisLookupOptions;
import net.wicp.tams.common.redis.RedisAssit;
import net.wicp.tams.common.redis.pool.AbsPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;

public class RedisCommandsContainerBuilder {
    private static AbsPool standalone;
    private static RedisLookupOptions redisLookupOptions;

    public static RedisCommandsContainer build(FlinkJedisConfigBase flinkJedisConfigBase) {
        if (flinkJedisConfigBase instanceof FlinkJedisPoolConfig) {
            FlinkJedisPoolConfig flinkJedisPoolConfig = (FlinkJedisPoolConfig)flinkJedisConfigBase;
            return RedisCommandsContainerBuilder.build(flinkJedisPoolConfig);
        }
        throw new IllegalArgumentException("Jedis configuration not found");
    }

    public static RedisCommandsContainer build(RedisLookupOptions redisLookupOptions) {
        String serverName = redisLookupOptions.getGroupid();
        if (standalone == null || !standalone.isInit()) {
            standalone = RedisAssit.standalone((String)serverName);
        }
        return new RedisContainer(standalone);
    }

    public static RedisCommandsContainer build(FlinkJedisPoolConfig jedisPoolConfig) {
        Objects.requireNonNull(jedisPoolConfig, "Redis pool config should not be Null");
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setMaxIdle(jedisPoolConfig.getMaxIdle());
        genericObjectPoolConfig.setMaxTotal(jedisPoolConfig.getMaxTotal());
        genericObjectPoolConfig.setMinIdle(jedisPoolConfig.getMinIdle());
        JedisPool jedisPool = new JedisPool(genericObjectPoolConfig, jedisPoolConfig.getHost(), jedisPoolConfig.getPort(), jedisPoolConfig.getConnectionTimeout(), jedisPoolConfig.getPassword(), jedisPoolConfig.getDatabase());
        return new RedisContainer(jedisPool);
    }
}

