/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.connector.redis.mapper;


import org.apache.flink.table.data.RowData;


public class SetRedisMapper implements RedisMapper<RowData> {

    @Override
    public RedisCommandDescription getCommandDescription() {
        return new RedisCommandDescription(RedisCommand.SET);
    }

    @Override
    public String getKeyFromData(RowData data) {
        return data.getString(0).toString();
    }

    @Override
    public String getValueFromData(RowData data) {
        return data.getString(1).toString();
    }
}
