/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.connector.redis.container;

import java.io.Closeable;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * The container for all available Redis commands.
 */
public interface RedisCommandsContainer extends Closeable, Serializable {

    void open() throws Exception;

    byte[] get(byte[] key);

    List<Object> multiGet(List<byte[]> key);

    byte[] hget(byte[] key, byte[] hashField);

    Map<String, String> hgetAll(String key);
}
