/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.connector.redis;

import static net.wicp.tams.common.flink.connector.redis.options.RedisSourceOptions.groupid;
import static net.wicp.tams.common.flink.connector.redis.options.RedisSourceOptions.host;
import static net.wicp.tams.common.flink.connector.redis.options.RedisSourceOptions.lookupcachemaxrows;
import static net.wicp.tams.common.flink.connector.redis.options.RedisSourceOptions.lookupcachettlsec;
import static net.wicp.tams.common.flink.connector.redis.options.RedisSourceOptions.password;
import static net.wicp.tams.common.flink.connector.redis.options.RedisSourceOptions.port;
import static net.wicp.tams.common.flink.connector.redis.options.RedisSourceOptions.searchkeyprefix;

import java.util.HashSet;
import java.util.Set;

import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;

import net.wicp.tams.common.flink.common.CommonOptions;
import net.wicp.tams.common.flink.common.DuckulaFormatFactory;
import net.wicp.tams.common.flink.connector.redis.options.RedisLookupOptions;
import net.wicp.tams.common.flink.connector.redis.options.RedisSourceOptions;
import net.wicp.tams.common.flink.connector.redis.sink.RedisDynamicTableSink;
import net.wicp.tams.common.flink.connector.redis.source.RedisDynamicTableSource;

public class RedisDynamicTableFactory implements DynamicTableSourceFactory, DynamicTableSinkFactory {

	@Override
	public String factoryIdentifier() {
		return RedisDynamicTableSource.IDENTIFIER;
	}

	@Override
	public Set<ConfigOption<?>> requiredOptions() {
		final Set<ConfigOption<?>> options = new HashSet<>();
		options.add(host);
		options.add(port);
		options.add(groupid);
		options.add(searchkeyprefix);
		return options;
	}

	@Override
	public Set<ConfigOption<?>> optionalOptions() {
		final Set<ConfigOption<?>> options = new HashSet<>();
		options.add(FactoryUtil.FORMAT); // 需要formate参数，用于sink时消息。
		options.add(password);
		options.add(lookupcachemaxrows);
		options.add(lookupcachettlsec);
		options.add(RedisSourceOptions.db);
		// options.add(RedisSourceOptions.controlkey);
		options.add(RedisSourceOptions.streamkey);
		options.add(RedisSourceOptions.groupkey);
		options.add(RedisSourceOptions.updateColName);
		options.add(RedisSourceOptions.routeColName);
		options.add(RedisSourceOptions.fieldFormart);

//        options.add(lookupmaxretries);
//        options.add(WRITE_MODE);
//        options.add(IS_BATCH_MODE);
//        options.add(BATCH_SIZE);
//        options.add(RedisSourceOptions.parallelism);
		options.add(RedisSourceOptions.append);
		return options;
	}

	@Override
	public DynamicTableSource createDynamicTableSource(Context context) {

		// either implement your custom validation logic here ...
		// or use the provided helper utility
		final FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper(this, context);

		// discover a suitable decoding format
//        final DecodingFormat<DeserializationSchema<RowData>> decodingFormat = helper.discoverDecodingFormat(
//                DeserializationFormatFactory.class,
//                FactoryUtil.FORMAT);
//        final DecodingFormat<DeserializationSchema<RowData>> decodingFormat =
		// validate all options
		helper.validate();

		// get the validated options
		final Configuration options = (Configuration) helper.getOptions();
		RedisSourceOptions.packageOptions(options);
		final RedisLookupOptions redisLookupOptions = RedisSourceOptions.getRedisLookupOptions(options);

//        TableSchema schema = context.getCatalogTable().getSchema();
		final ResolvedSchema schema = context.getCatalogTable().getResolvedSchema();
		//flink15错误，干掉：java.lang.ClassCastException: org.apache.flink.table.api.TableConfig cannot be cast to org.apache.flink.configuration.Configuration
//		Configuration c = (Configuration) context.getConfiguration();
//		boolean isDimBatchMode = c.getBoolean("is.dim.batch.mode", false);

		return new RedisDynamicTableSource(schema, null, redisLookupOptions, 
				options);
	}

	@Override
	public DynamicTableSink createDynamicTableSink(Context context) {
		final FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper(this, context);
		helper.validate();
		final ResolvedSchema schema = context.getCatalogTable().getResolvedSchema();
		// get the validated options
		final Configuration options = (Configuration) helper.getOptions();
		RedisSourceOptions.packageOptions(options);

		if (!options.getOptional(FactoryUtil.FORMAT).isPresent()) {// 不存在时需要配置一个默认的。否则discoverEncodingFormat会出错。
			options.set(FactoryUtil.FORMAT, DuckulaFormatFactory.IDENTIFIER);
		}
		EncodingFormat<SerializationSchema<RowData>> encodingFormat = helper
				.discoverEncodingFormat(SerializationFormatFactory.class, FactoryUtil.FORMAT);
		return new RedisDynamicTableSink(schema, encodingFormat, options);
	}

}