/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.connector.redis.options;

import java.time.Duration;
import java.util.Properties;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.constant.ods.AddColName;
import net.wicp.tams.common.flink.connector.redis.options.RedisLookupOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;

public abstract class RedisSourceOptions {
    public static final ConfigOption<String> host = ConfigOptions.key((String)"host").stringType().noDefaultValue().withDescription("\u4e3b\u673a");
    public static final ConfigOption<String> controlkey = ConfigOptions.key((String)"controlkey").stringType().noDefaultValue().withDescription("\u7ec4\u7684key\uff0c\u7528\u4e8e\u5b58\u653e\u6b64\u8868\u4e2d\u7684\u6240\u6709id,\u76f8\u5173\u4e8e\u8868\u7684\u7d22\u5f15");
    public static final ConfigOption<String> searchkeyprefix = ConfigOptions.key((String)"searchkeyprefix").stringType().noDefaultValue().withDescription("redis_key\u7684\u524d\u7f00\uff0c\u901a\u5e38\u4ee5dim:db:table\u8868\u793a");
    public static final ConfigOption<String> groupid = ConfigOptions.key((String)"groupid").stringType().noDefaultValue().withDescription("stream\u7684\u6d88\u8d39groupid");
    public static final ConfigOption<String> updateColName = ConfigOptions.key((String)"updateColName").stringType().defaultValue((Object)AddColName.commitTime.getColNameTrue()).withDescription("\u7528\u4e8e\u5206\u9694\u5168\u91cf\u548c\u589e\u91cf\u7684\u65f6\u95f4\u5b57\u6bb5");
    public static final ConfigOption<String> routeColName = ConfigOptions.key((String)"routeColName").stringType().noDefaultValue().withDescription("\u8def\u7531\u5b57\u6bb5");
    public static final ConfigOption<String> fieldFormart = ConfigOptions.key((String)"fieldFormart").stringType().defaultValue((Object)"ori").withDescription("\u6240\u6709\u5b57\u6bb5\u7684\u683c\u5f0f");
    public static final ConfigOption<Boolean> append = ConfigOptions.key((String)"append").booleanType().defaultValue((Object)false).withDescription("\u662f\u5426\u4e3aappend\u6a21\u5f0f");
    public static final ConfigOption<Integer> port = ConfigOptions.key((String)"port").intType().defaultValue((Object)6379).withDescription("\u7aef\u53e3");
    public static final ConfigOption<Integer> db = ConfigOptions.key((String)"db").intType().defaultValue((Object)0).withDescription("\u6570\u636e\u5e93");
    public static final ConfigOption<String> password = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("\u5bc6\u7801");
    public static final ConfigOption<String> streamkey = ConfigOptions.key((String)"streamkey").stringType().noDefaultValue().withDescription("pub\u7684key");
    public static final ConfigOption<String> groupkey = ConfigOptions.key((String)"groupkey").stringType().noDefaultValue().withDescription("\u5b58\u653e\u6240\u6709\u8bb0\u5f55\u7684key\u96c6\u5408");
    public static final ConfigOption<Long> lookupcachemaxrows = ConfigOptions.key((String)"lookup.cache.max-rows").longType().defaultValue((Object)100000L).withDescription("\u7f13\u5b58\u6700\u5927\u884c\u6570");
    public static final ConfigOption<Duration> lookupcachettlsec = ConfigOptions.key((String)"lookup.cache.ttl-sec").durationType().defaultValue((Object)Duration.ofSeconds(600L)).withDescription("\u7f13\u5b58\u8d85\u671f\u65f6\u95f4");
    public static final ConfigOption<Boolean> lookupasync = ConfigOptions.key((String)"lookup.async").booleanType().defaultValue((Object)false).withDescription("whether to set async lookup.");
    public static final ConfigOption<Integer> lookupmaxretries = ConfigOptions.key((String)"lookup.max-retries").intType().defaultValue((Object)1).withDescription("the max retry times if lookup database failed.");

    public static void packageOptions(ReadableConfig options) {
        Properties props = new Properties();
        String serverName = (String)options.get(groupid);
        props.put(String.format("common.redis.redisserver.%s.defaultDb", serverName), options.get(db));
        if (options.getOptional(password).isPresent()) {
            props.put(String.format("common.redis.redisserver.%s.password", serverName), options.get(password));
        }
        props.put(String.format("common.redis.redisserver.%s.host", serverName), options.get(host));
        props.put(String.format("common.redis.redisserver.%s.port", serverName), ((Integer)options.get(port)).toString());
        String streamkey = null;
        streamkey = options.getOptional(RedisSourceOptions.streamkey).isPresent() ? (String)options.getOptional(RedisSourceOptions.streamkey).get() : String.format("%s:%s:%s", options.get(searchkeyprefix), "control", "stream");
        String groupkey = null;
        groupkey = options.getOptional(RedisSourceOptions.groupkey).isPresent() ? (String)options.getOptional(RedisSourceOptions.groupkey).get() : String.format("%s:%s:%s", options.get(searchkeyprefix), "control", "group");
        props.put(String.format("common.redis.redisserver.%s.streamkey", serverName), streamkey);
        props.put(String.format("common.redis.redisserver.%s.groupkey", serverName), groupkey);
        Conf.overProp((Properties)props);
    }

    public static RedisLookupOptions getRedisLookupOptions(ReadableConfig tableOptions) {
        return RedisLookupOptions.builder().setLookupAsync((Boolean)tableOptions.get(lookupasync)).setMaxRetryTimes((Integer)tableOptions.get(lookupmaxretries)).setCacheExpireMs(((Duration)tableOptions.get(lookupcachettlsec)).toMillis()).setCacheMaxSize((Long)tableOptions.get(lookupcachemaxrows)).setHostname((String)tableOptions.get(host)).setPort((Integer)tableOptions.get(port)).setSearchkeyprefix((String)tableOptions.get(searchkeyprefix)).setGroupid((String)tableOptions.get(groupid)).build();
    }
}

