/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.connector.redis;

import java.util.HashSet;
import java.util.Set;
import net.wicp.tams.common.flink.connector.redis.options.RedisLookupOptions;
import net.wicp.tams.common.flink.connector.redis.options.RedisSourceOptions;
import net.wicp.tams.common.flink.connector.redis.sink.RedisDynamicTableSink;
import net.wicp.tams.common.flink.connector.redis.source.RedisDynamicTableSource;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;

public class RedisDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public String factoryIdentifier() {
        return "redis";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(RedisSourceOptions.host);
        options.add(RedisSourceOptions.port);
        options.add(RedisSourceOptions.groupid);
        options.add(RedisSourceOptions.searchkeyprefix);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(FactoryUtil.FORMAT);
        options.add(RedisSourceOptions.password);
        options.add(RedisSourceOptions.lookupcachemaxrows);
        options.add(RedisSourceOptions.lookupcachettlsec);
        options.add(RedisSourceOptions.db);
        options.add(RedisSourceOptions.streamkey);
        options.add(RedisSourceOptions.groupkey);
        options.add(RedisSourceOptions.updateColName);
        options.add(RedisSourceOptions.routeColName);
        options.add(RedisSourceOptions.fieldFormart);
        options.add(RedisSourceOptions.append);
        return options;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validate();
        Configuration options = (Configuration)helper.getOptions();
        RedisSourceOptions.packageOptions((ReadableConfig)options);
        RedisLookupOptions redisLookupOptions = RedisSourceOptions.getRedisLookupOptions((ReadableConfig)options);
        ResolvedSchema schema = context.getCatalogTable().getResolvedSchema();
        return new RedisDynamicTableSource(schema, null, redisLookupOptions, options);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validate();
        ResolvedSchema schema = context.getCatalogTable().getResolvedSchema();
        Configuration options = (Configuration)helper.getOptions();
        RedisSourceOptions.packageOptions((ReadableConfig)options);
        if (!options.getOptional(FactoryUtil.FORMAT).isPresent()) {
            options.set(FactoryUtil.FORMAT, (Object)"duckula");
        }
        EncodingFormat encodingFormat = helper.discoverEncodingFormat(SerializationFormatFactory.class, FactoryUtil.FORMAT);
        return new RedisDynamicTableSink(schema, (EncodingFormat<SerializationSchema<RowData>>)encodingFormat, options);
    }
}

