/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.connector.redis.source;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.wicp.tams.common.flink.connector.redis.config.FlinkJedisPoolConfig;
import net.wicp.tams.common.flink.connector.redis.connector.RedisRowDataLookupFunction;
import net.wicp.tams.common.flink.connector.redis.connector.RedisScanFunction;
import net.wicp.tams.common.flink.connector.redis.mapper.LookupRedisMapper;
import net.wicp.tams.common.flink.connector.redis.options.RedisLookupOptions;
import net.wicp.tams.common.flink.connector.redis.options.RedisSourceOptions;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.TableFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class RedisDynamicTableSource
implements LookupTableSource,
ScanTableSource {
    public static final String IDENTIFIER = "redis";
    protected final ResolvedSchema schema;
    private List<RowType.RowField> fields;
    @Nullable
    protected final DecodingFormat<DeserializationSchema<RowData>> decodingFormat;
    protected final RedisLookupOptions redisLookupOptions;
    private Configuration optionsWith;

    public RedisDynamicTableSource(ResolvedSchema schema, DecodingFormat<DeserializationSchema<RowData>> decodingFormat, RedisLookupOptions redisLookupOptions, Configuration c) {
        this.schema = schema;
        Preconditions.checkNotNull((Object)schema.toPhysicalRowDataType(), (String)"Physical data type must not be null.");
        this.decodingFormat = decodingFormat;
        this.redisLookupOptions = redisLookupOptions;
        this.optionsWith = c;
    }

    public LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupTableSource.LookupContext context) {
        String[] keyNames = new String[context.getKeys().length];
        for (int i = 0; i < keyNames.length; ++i) {
            int[] innerKeyArr = context.getKeys()[i];
            Preconditions.checkArgument((innerKeyArr.length == 1 ? 1 : 0) != 0, (Object)"redis only support non-nested look up keys");
            keyNames[i] = (String)this.schema.getColumnNames().get(innerKeyArr[0]);
        }
        FlinkJedisPoolConfig flinkJedisConfigBase = new FlinkJedisPoolConfig.Builder().setHost(this.redisLookupOptions.getHostname()).setPort(this.redisLookupOptions.getPort()).build();
        LookupRedisMapper lookupRedisMapper = new LookupRedisMapper(this.createDeserialization((DynamicTableSource.Context)context, this.decodingFormat, RedisScanFunction.createValueFormatProjection(this.schema.toPhysicalRowDataType())));
        return TableFunctionProvider.of((TableFunction)new RedisRowDataLookupFunction(flinkJedisConfigBase, lookupRedisMapper, this.redisLookupOptions, this.schema.toPhysicalRowDataType(), this.optionsWith, keyNames));
    }

    @Nullable
    private DeserializationSchema<RowData> createDeserialization(DynamicTableSource.Context context, @Nullable DecodingFormat<DeserializationSchema<RowData>> format, int[] projection) {
        if (format == null) {
            return null;
        }
        DataType physicalFormatDataType = DataTypeUtils.projectRow((DataType)this.schema.toPhysicalRowDataType(), (int[])projection);
        return (DeserializationSchema)format.createRuntimeDecoder(context, physicalFormatDataType);
    }

    public DynamicTableSource copy() {
        return new RedisDynamicTableSource(this.schema, this.decodingFormat, this.redisLookupOptions, this.optionsWith);
    }

    public String asSummaryString() {
        return IDENTIFIER;
    }

    public ChangelogMode getChangelogMode() {
        boolean append = (Boolean)this.optionsWith.get(RedisSourceOptions.append);
        return append ? ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).build() : ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        RowType rowType = (RowType)this.schema.toPhysicalRowDataType().getLogicalType();
        this.fields = rowType.getFields();
        Optional primaryKeyopt = this.schema.getPrimaryKey();
        UniqueConstraint primaryKey = primaryKeyopt.isPresent() ? (UniqueConstraint)primaryKeyopt.get() : null;
        RedisScanFunction sourceFunction = new RedisScanFunction(this.optionsWith, this.fields, primaryKey);
        return SourceFunctionProvider.of((SourceFunction)sourceFunction, (boolean)false);
    }
}

